<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Terms & Conditions - RISTOPUP</title>
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/home.css') }}?v={{ time() }}">
    <link rel="stylesheet" href="{{ asset('css/terms.css') }}">
</head>
<body>
    @include('layouts.header')

    <div class="terms-wrapper">
        <div class="terms-container">
            <a href="{{ route('home') }}" class="back-btn">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M19 12H5M12 19l-7-7 7-7"/>
                </svg>
                Back to Home
            </a>

            <div class="terms-card">
                <div class="terms-header">
                    <h1>Terms & Conditions</h1>
                    <p>Last updated: {{ date('F d, Y') }}</p>
                </div>

                <div class="terms-content">

            <h2>1. Acceptance of Terms</h2>
            <p>By accessing and using WebTopUp ("the Service"), you accept and agree to be bound by the terms and provision of this agreement. If you do not agree to abide by the above, please do not use this service.</p>

            <h2>2. Use of Service</h2>
            <h3>2.1 Eligibility</h3>
            <p>You must be at least 13 years old to use this service. By using the Service, you represent and warrant that you meet this requirement.</p>

            <h3>2.2 Account Registration</h3>
            <p>To access certain features of the Service, you must register for an account. You agree to:</p>
            <ul>
                <li>Provide accurate, current, and complete information during registration</li>
                <li>Maintain the security of your password and account</li>
                <li>Notify us immediately of any unauthorized use of your account</li>
                <li>Accept responsibility for all activities that occur under your account</li>
            </ul>

            <h2>3. Gaming Services</h2>
            <h3>3.1 Virtual Items and Currency</h3>
            <p>Any virtual items, currency, or benefits purchased through the Service are licensed, not sold, to you. We reserve the right to manage, regulate, control, modify, or eliminate virtual items at any time.</p>

            <h3>3.2 Top-Up Services</h3>
            <p>When using our top-up services:</p>
            <ul>
                <li>All transactions are final and non-refundable unless required by law</li>
                <li>You must provide accurate game account information</li>
                <li>Processing times may vary depending on the game provider</li>
                <li>We are not responsible for incorrect account details provided by you</li>
            </ul>

            <h2>4. Payment Terms</h2>
            <p>All payments are processed securely through our payment partners. By making a purchase, you agree to:</p>
            <ul>
                <li>Provide accurate payment information</li>
                <li>Pay all charges at the prices in effect when incurred</li>
                <li>Pay applicable taxes</li>
                <li>Authorize us to charge your payment method</li>
            </ul>

            <h2>5. User Conduct</h2>
            <p>You agree not to:</p>
            <ul>
                <li>Use the Service for any illegal purpose or in violation of any laws</li>
                <li>Impersonate any person or entity or misrepresent your affiliation</li>
                <li>Interfere with or disrupt the Service or servers</li>
                <li>Attempt to gain unauthorized access to any portion of the Service</li>
                <li>Use any automated system to access the Service</li>
                <li>Engage in any fraudulent activities</li>
            </ul>

            <h2>6. Privacy</h2>
            <p>Your privacy is important to us. Our Privacy Policy explains how we collect, use, and protect your personal information. By using the Service, you consent to our collection and use of personal data as outlined in our Privacy Policy.</p>

            <h2>7. Intellectual Property</h2>
            <p>All content, features, and functionality of the Service are owned by WebTopUp and are protected by international copyright, trademark, patent, trade secret, and other intellectual property laws.</p>

            <h2>8. Limitation of Liability</h2>
            <p>To the maximum extent permitted by law, WebTopUp shall not be liable for any indirect, incidental, special, consequential, or punitive damages, or any loss of profits or revenues, whether incurred directly or indirectly.</p>

            <h2>9. Service Modifications</h2>
            <p>We reserve the right to:</p>
            <ul>
                <li>Modify or discontinue the Service at any time</li>
                <li>Change these Terms at any time</li>
                <li>Refuse service to anyone for any reason</li>
            </ul>

            <h2>10. Termination</h2>
            <p>We may terminate or suspend your account and access to the Service immediately, without prior notice, for any reason, including but not limited to breach of these Terms.</p>

            <h2>11. Dispute Resolution</h2>
            <p>Any disputes arising out of or relating to these Terms or the Service shall be resolved through good faith negotiations. If negotiations fail, disputes shall be subject to the exclusive jurisdiction of the courts.</p>

            <h2>12. Contact Information</h2>
            <p>If you have any questions about these Terms & Conditions, please contact us at:</p>
            <ul>
                <li>Email: support@webtopup.com</li>
                <li>Website: {{ url('/') }}</li>
            </ul>

            <div class="highlight-box" style="margin-top: 40px;">
                <strong>Agreement:</strong> By clicking "I agree to the Terms & Conditions" during registration, you acknowledge that you have read, understood, and agree to be bound by these Terms & Conditions.
            </div>
                </div>
            </div>
        </div>
    </div>

    @include('layouts.footer')
</body>
</html>
