<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Status Pesanan - {{ $order->order_id }} - RISTOPUP</title>
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/home.css') }}?v={{ time() }}">
    <link rel="stylesheet" href="{{ asset('css/order.css') }}?v={{ time() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    @include('layouts.header')

    <div class="container">
        <main class="main-content status-page">
            <!-- Status Header -->
            <div class="status-header status-{{ $order->status }}">
                <div class="status-icon">
                    @if($order->status === 'completed')
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                        <polyline points="22 4 12 14.01 9 11.01"/>
                    </svg>
                    @elseif($order->status === 'pending')
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <polyline points="12 6 12 12 16 14"/>
                    </svg>
                    @elseif($order->status === 'processing' || $order->status === 'paid')
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 2v4m0 12v4M4.93 4.93l2.83 2.83m8.48 8.48l2.83 2.83M2 12h4m12 0h4M4.93 19.07l2.83-2.83m8.48-8.48l2.83-2.83"/>
                    </svg>
                    @elseif($order->status === 'failed' || $order->status === 'expired')
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="15" y1="9" x2="9" y2="15"/>
                        <line x1="9" y1="9" x2="15" y2="15"/>
                    </svg>
                    @else
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="12" y1="8" x2="12" y2="12"/>
                        <line x1="12" y1="16" x2="12.01" y2="16"/>
                    </svg>
                    @endif
                </div>
                <h1>{{ $order->getStatusLabel() }}</h1>
                <p class="status-description">
                    @if($order->status === 'completed')
                    Pesanan kamu telah berhasil diproses!
                    @elseif($order->status === 'pending')
                    Menunggu pembayaran dari kamu
                    @elseif($order->status === 'paid')
                    Pembayaran diterima, sedang diverifikasi
                    @elseif($order->status === 'processing')
                    Pesanan sedang dalam proses pengiriman
                    @elseif($order->status === 'failed')
                    Maaf, pesanan kamu gagal diproses
                    @elseif($order->status === 'expired')
                    Waktu pembayaran telah habis
                    @elseif($order->status === 'refunded')
                    Dana telah dikembalikan
                    @endif
                </p>
            </div>

            <!-- Order ID -->
            <div class="order-id-display">
                <span class="label">Order ID:</span>
                <span class="value">{{ $order->order_id }}</span>
                <button class="btn-copy-small" onclick="copyToClipboard('{{ $order->order_id }}')">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="16" height="16">
                        <rect x="9" y="9" width="13" height="13" rx="2" ry="2"/>
                        <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"/>
                    </svg>
                </button>
            </div>

            @if(session('success'))
            <div class="alert-success">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                    <polyline points="22 4 12 14.01 9 11.01"/>
                </svg>
                {{ session('success') }}
            </div>
            @endif

            @if(session('error'))
            <div class="alert-error">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <circle cx="12" cy="12" r="10"/>
                    <line x1="15" y1="9" x2="9" y2="15"/>
                    <line x1="9" y1="9" x2="15" y2="15"/>
                </svg>
                {{ session('error') }}
            </div>
            @endif

            <!-- Order Timeline -->
            <div class="order-timeline">
                <div class="timeline-item {{ in_array($order->status, ['pending', 'paid', 'processing', 'completed']) ? 'active' : '' }} {{ $order->status === 'expired' || $order->status === 'failed' ? 'failed' : '' }}">
                    <div class="timeline-dot"></div>
                    <div class="timeline-content">
                        <strong>Pesanan Dibuat</strong>
                        <span>{{ $order->created_at->format('d M Y, H:i') }}</span>
                    </div>
                </div>
                <div class="timeline-item {{ in_array($order->status, ['paid', 'processing', 'completed']) ? 'active' : '' }}">
                    <div class="timeline-dot"></div>
                    <div class="timeline-content">
                        <strong>Pembayaran</strong>
                        @if($order->paid_at)
                        <span>{{ $order->paid_at->format('d M Y, H:i') }}</span>
                        @else
                        <span>Menunggu pembayaran</span>
                        @endif
                    </div>
                </div>
                <div class="timeline-item {{ in_array($order->status, ['processing', 'completed']) ? 'active' : '' }}">
                    <div class="timeline-dot"></div>
                    <div class="timeline-content">
                        <strong>Diproses</strong>
                        <span>{{ $order->status === 'processing' ? 'Sedang diproses' : ($order->completed_at ? 'Selesai' : '-') }}</span>
                    </div>
                </div>
                <div class="timeline-item {{ $order->status === 'completed' ? 'active' : '' }}">
                    <div class="timeline-dot"></div>
                    <div class="timeline-content">
                        <strong>Selesai</strong>
                        @if($order->completed_at)
                        <span>{{ $order->completed_at->format('d M Y, H:i') }}</span>
                        @else
                        <span>-</span>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Order Details -->
            <div class="status-grid">
                <div class="status-main">
                    <div class="status-card">
                        <h2>Detail Pesanan</h2>
                        
                        <div class="order-product-detail">
                            <div class="product-image">
                                <img src="{{ asset('storage/' . $order->product->game->image) }}" alt="{{ $order->product->game->name }}">
                            </div>
                            <div class="product-info">
                                <h3>{{ $order->product->game->name }}</h3>
                                <p>{{ $order->product->name }}</p>
                                @if($order->isFlashSaleOrder())
                                <span class="flash-sale-tag">
                                    <svg viewBox="0 0 24 24" fill="currentColor" width="12" height="12">
                                        <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/>
                                    </svg>
                                    Flash Sale
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="detail-grid">
                            <div class="detail-item">
                                <span class="detail-label">ID Game</span>
                                <span class="detail-value">{{ $order->game_user_id }}</span>
                            </div>
                            @if($order->game_server_id)
                            <div class="detail-item">
                                <span class="detail-label">Server ID</span>
                                <span class="detail-value">{{ $order->game_server_id }}</span>
                            </div>
                            @endif
                            <div class="detail-item">
                                <span class="detail-label">WhatsApp</span>
                                <span class="detail-value">{{ $order->whatsapp }}</span>
                            </div>
                            <div class="detail-item">
                                <span class="detail-label">Metode Pembayaran</span>
                                <span class="detail-value">{{ $order->payment_method ? ucfirst(str_replace('_', ' ', $order->payment_method)) : '-' }}</span>
                            </div>
                        </div>
                    </div>

                    @if($order->status === 'pending' && $order->canBePaid())
                    <div class="status-card pending-action">
                        <h2>Lanjutkan Pembayaran</h2>
                        <p>Pesanan akan kadaluarsa pada {{ $order->expired_at->format('d M Y, H:i') }}</p>
                        <a href="{{ route('order.checkout', $order->order_id) }}" class="btn-pay-now">
                            Bayar Sekarang
                        </a>
                    </div>
                    @endif
                </div>

                <div class="status-sidebar">
                    <div class="status-card price-card">
                        <h3>Ringkasan Pembayaran</h3>
                        
                        <div class="price-row">
                            <span>Harga Produk</span>
                            <span>Rp {{ number_format($order->original_price, 0, ',', '.') }}</span>
                        </div>
                        
                        @if($order->discount > 0)
                        <div class="price-row discount">
                            <span>Diskon</span>
                            <span>- Rp {{ number_format($order->discount, 0, ',', '.') }}</span>
                        </div>
                        @endif
                        
                        <div class="price-row total">
                            <span>Total Dibayar</span>
                            <span>Rp {{ number_format($order->price, 0, ',', '.') }}</span>
                        </div>
                    </div>

                    <div class="status-card">
                        <h3>Butuh Bantuan?</h3>
                        <p>Ada masalah dengan pesanan? Hubungi kami</p>
                        <a href="https://wa.me/6281234567890?text=Halo,%20saya%20butuh%20bantuan%20untuk%20order%20{{ $order->order_id }}" target="_blank" class="btn-whatsapp">
                            <svg viewBox="0 0 24 24" fill="currentColor" width="18" height="18">
                                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                            </svg>
                            Chat WhatsApp
                        </a>
                    </div>

                    <a href="{{ route('home') }}" class="btn-back-home">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="18" height="18">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                            <polyline points="9 22 9 12 15 12 15 22"/>
                        </svg>
                        Kembali ke Beranda
                    </a>
                </div>
            </div>
        </main>
    </div>

    @include('layouts.footer')

    <script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(() => {
            alert('Order ID disalin!');
        });
    }
    </script>
</body>
</html>
