<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Checkout - {{ $order->order_id }} - RISTOPUP</title>
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/home.css') }}?v={{ time() }}">
    <link rel="stylesheet" href="{{ asset('css/order.css') }}?v={{ time() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    @include('layouts.header')

    <div class="container">
        <main class="main-content checkout-page">
            <!-- Order Success Banner -->
            <div class="order-created-banner">
                <div class="banner-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                        <polyline points="22 4 12 14.01 9 11.01"/>
                    </svg>
                </div>
                <h1>Pesanan Berhasil Dibuat!</h1>
                <p>Simpan Order ID kamu untuk melacak pesanan</p>
            </div>

            <!-- Order ID Card -->
            <div class="order-id-card">
                <div class="order-id-label">Order ID</div>
                <div class="order-id-value" id="orderId">{{ $order->order_id }}</div>
                <button class="btn-copy" onclick="copyOrderId()">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="9" y="9" width="13" height="13" rx="2" ry="2"/>
                        <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"/>
                    </svg>
                    Salin
                </button>
                <div class="copy-success" id="copySuccess">Order ID disalin!</div>
            </div>

            <!-- Important Notice -->
            <div class="important-notice">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <circle cx="12" cy="12" r="10"/>
                    <line x1="12" y1="8" x2="12" y2="12"/>
                    <line x1="12" y1="16" x2="12.01" y2="16"/>
                </svg>
                <div>
                    <strong>Penting!</strong>
                    <p>Simpan Order ID di atas. Anda memerlukan Order ID ini untuk melacak status pesanan. Tanpa login, ini adalah satu-satunya cara untuk mengakses pesanan Anda.</p>
                </div>
            </div>

            <!-- Countdown Timer -->
            <div class="payment-countdown">
                <div class="countdown-label">Selesaikan pembayaran dalam:</div>
                <div class="countdown-timer" id="paymentCountdown" data-expired="{{ $order->expired_at->timestamp }}">
                    <div class="countdown-unit">
                        <span class="countdown-value" id="countHours">00</span>
                        <span class="countdown-text">Jam</span>
                    </div>
                    <span class="countdown-separator">:</span>
                    <div class="countdown-unit">
                        <span class="countdown-value" id="countMinutes">00</span>
                        <span class="countdown-text">Menit</span>
                    </div>
                    <span class="countdown-separator">:</span>
                    <div class="countdown-unit">
                        <span class="countdown-value" id="countSeconds">00</span>
                        <span class="countdown-text">Detik</span>
                    </div>
                </div>
            </div>

            <!-- Order Details -->
            <div class="checkout-grid">
                <div class="checkout-main">
                    <!-- Order Summary -->
                    <div class="checkout-card">
                        <h2>Detail Pesanan</h2>
                        
                        <div class="order-product">
                            <div class="product-image">
                                <img src="{{ asset('storage/' . $order->product->game->image) }}" alt="{{ $order->product->game->name }}">
                            </div>
                            <div class="product-details">
                                <h3>{{ $order->product->game->name }}</h3>
                                <p class="product-name">{{ $order->product->name }}</p>
                                @if($order->isFlashSaleOrder())
                                <span class="flash-sale-tag">
                                    <svg viewBox="0 0 24 24" fill="currentColor" width="12" height="12">
                                        <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/>
                                    </svg>
                                    Flash Sale
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="order-info-grid">
                            <div class="info-item">
                                <span class="info-label">ID Game</span>
                                <span class="info-value">{{ $order->game_user_id }}</span>
                            </div>
                            @if($order->game_server_id)
                            <div class="info-item">
                                <span class="info-label">Server ID</span>
                                <span class="info-value">{{ $order->game_server_id }}</span>
                            </div>
                            @endif
                            <div class="info-item">
                                <span class="info-label">WhatsApp</span>
                                <span class="info-value">{{ $order->whatsapp }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Method -->
                    <div class="checkout-card">
                        <h2>Metode Pembayaran</h2>
                        <p class="payment-note">Pilih metode pembayaran untuk melanjutkan</p>

                        <form action="{{ route('order.confirm', $order->order_id) }}" method="POST" enctype="multipart/form-data" id="paymentForm">
                            @csrf
                            
                            <div class="payment-methods">
                                <label class="payment-option">
                                    <input type="radio" name="payment_method" value="qris" checked>
                                    <div class="payment-option-content">
                                        <div class="payment-icon">
                                            <img src="{{ asset('images/qris-icon.png') }}" alt="QRIS" onerror="this.src='data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 24 24%22 fill=%22%23666%22><rect width=%2224%22 height=%2224%22 rx=%224%22/><text x=%2212%22 y=%2216%22 text-anchor=%22middle%22 fill=%22white%22 font-size=%228%22>QR</text></svg>'">
                                        </div>
                                        <div class="payment-info">
                                            <strong>QRIS</strong>
                                            <span>Scan QR dengan e-wallet apapun</span>
                                        </div>
                                    </div>
                                </label>

                                <label class="payment-option">
                                    <input type="radio" name="payment_method" value="ewallet">
                                    <div class="payment-option-content">
                                        <div class="payment-icon">💳</div>
                                        <div class="payment-info">
                                            <strong>E-Wallet</strong>
                                            <span>GoPay, OVO, DANA, ShopeePay</span>
                                        </div>
                                    </div>
                                </label>

                                <label class="payment-option">
                                    <input type="radio" name="payment_method" value="bank_transfer">
                                    <div class="payment-option-content">
                                        <div class="payment-icon">🏦</div>
                                        <div class="payment-info">
                                            <strong>Transfer Bank</strong>
                                            <span>BCA, BNI, BRI, Mandiri</span>
                                        </div>
                                    </div>
                                </label>

                                <label class="payment-option">
                                    <input type="radio" name="payment_method" value="manual">
                                    <div class="payment-option-content">
                                        <div class="payment-icon">📱</div>
                                        <div class="payment-info">
                                            <strong>Transfer Manual</strong>
                                            <span>Upload bukti pembayaran</span>
                                        </div>
                                    </div>
                                </label>
                            </div>

                            <!-- Manual Payment Proof (shown when manual selected) -->
                            <div class="manual-payment-section" id="manualPaymentSection" style="display: none;">
                                <div class="payment-instructions">
                                    <h4>Instruksi Transfer Manual</h4>
                                    <p>Transfer ke rekening berikut:</p>
                                    <div class="bank-info">
                                        <strong>Bank BCA</strong>
                                        <div class="account-number">1234567890</div>
                                        <span>a.n. RISTOPUP</span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="payment_proof">Upload Bukti Transfer</label>
                                    <input type="file" id="payment_proof" name="payment_proof" accept="image/*">
                                    <small>Format: JPG, PNG (Max 2MB)</small>
                                </div>
                            </div>

                            <button type="submit" class="btn-pay">
                                Bayar Sekarang - Rp {{ number_format($order->price, 0, ',', '.') }}
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="checkout-sidebar">
                    <div class="checkout-card price-summary">
                        <h3>Ringkasan Pembayaran</h3>
                        
                        <div class="price-row">
                            <span>Harga Produk</span>
                            <span>Rp {{ number_format($order->original_price, 0, ',', '.') }}</span>
                        </div>
                        
                        @if($order->discount > 0)
                        <div class="price-row discount">
                            <span>
                                Diskon
                                @if($order->isFlashSaleOrder())
                                <span class="flash-tag">Flash Sale</span>
                                @endif
                            </span>
                            <span>- Rp {{ number_format($order->discount, 0, ',', '.') }}</span>
                        </div>
                        @endif
                        
                        <div class="price-row total">
                            <span>Total Bayar</span>
                            <span>Rp {{ number_format($order->price, 0, ',', '.') }}</span>
                        </div>
                    </div>

                    <div class="checkout-card help-card">
                        <h3>Butuh Bantuan?</h3>
                        <p>Hubungi customer service kami</p>
                        <a href="https://wa.me/6281234567890" target="_blank" class="btn-whatsapp">
                            <svg viewBox="0 0 24 24" fill="currentColor">
                                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                            </svg>
                            Chat WhatsApp
                        </a>
                    </div>
                </div>
            </div>
        </main>
    </div>

    @include('layouts.footer')

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Copy Order ID
        window.copyOrderId = function() {
            const orderId = document.getElementById('orderId').textContent;
            navigator.clipboard.writeText(orderId).then(() => {
                const successEl = document.getElementById('copySuccess');
                successEl.classList.add('show');
                setTimeout(() => successEl.classList.remove('show'), 2000);
            });
        };

        // Payment method toggle
        const paymentOptions = document.querySelectorAll('input[name="payment_method"]');
        const manualSection = document.getElementById('manualPaymentSection');
        
        paymentOptions.forEach(option => {
            option.addEventListener('change', function() {
                if (this.value === 'manual') {
                    manualSection.style.display = 'block';
                } else {
                    manualSection.style.display = 'none';
                }
            });
        });

        // Countdown timer
        const countdownEl = document.getElementById('paymentCountdown');
        const expiredTime = parseInt(countdownEl.dataset.expired);
        
        function updateCountdown() {
            const now = Math.floor(Date.now() / 1000);
            const diff = expiredTime - now;
            
            if (diff <= 0) {
                document.getElementById('countHours').textContent = '00';
                document.getElementById('countMinutes').textContent = '00';
                document.getElementById('countSeconds').textContent = '00';
                // Redirect to status page
                window.location.href = '{{ route("order.status", $order->order_id) }}';
                return;
            }
            
            const hours = Math.floor(diff / 3600);
            const minutes = Math.floor((diff % 3600) / 60);
            const seconds = diff % 60;
            
            document.getElementById('countHours').textContent = hours.toString().padStart(2, '0');
            document.getElementById('countMinutes').textContent = minutes.toString().padStart(2, '0');
            document.getElementById('countSeconds').textContent = seconds.toString().padStart(2, '0');
        }
        
        updateCountdown();
        setInterval(updateCountdown, 1000);
    });
    </script>
</body>
</html>
