<!-- Top Header Navbar -->
<header class="main-header">
    <nav class="header-navbar">
        <div class="navbar-container">
            <div class="navbar-left">
                <a href="{{ route('home') }}" class="logo">
                    <img src="{{ asset('images/logojudulgerak.gif') }}?v={{ time() }}" alt="RISTOPUP Logo" loading="eager" decoding="async">
                </a>
                <div class="search-bar">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <circle cx="11" cy="11" r="8"/>
                        <path d="m21 21-4.35-4.35"/>
                    </svg>
                    <input type="text" placeholder="Cari game untuk top up...">
                </div>
            </div>
            
            <div class="navbar-right">
                <a href="{{ route('login') }}" class="btn-login btn-desktop-only">Masuk</a>
                <a href="{{ route('register') }}" class="btn-register btn-desktop-only">Daftar</a>
                
                <!-- All Apps Grid Icon -->
                <div class="all-apps-wrapper">
                    <button class="all-apps-btn" id="allAppsBtn">
                        <div class="grid-icon">
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </button>
                    
                    <!-- Dropdown Menu -->
                    <div class="all-apps-dropdown" id="allAppsDropdown">
                        @auth
                            <a href="{{ route('profile') }}" class="dropdown-item">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                                </svg>
                                <span>Profil Saya</span>
                            </a>
                            <a href="{{ route('profile') }}" class="dropdown-item">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M13 3c-4.97 0-9 4.03-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42C8.27 19.99 10.51 21 13 21c4.97 0 9-4.03 9-9s-4.03-9-9-9zm-1 5v5l4.28 2.54.72-1.21-3.5-2.08V8H12z"/>
                                </svg>
                                <span>Riwayat Transaksi</span>
                            </a>
                            <div class="dropdown-divider"></div>
                            <form action="{{ route('logout') }}" method="POST">
                                @csrf
                                <button type="submit" class="dropdown-item logout-item">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M17 7l-1.41 1.41L18.17 11H8v2h10.17l-2.58 2.58L17 17l5-5zM4 5h8V3H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h8v-2H4V5z"/>
                                    </svg>
                                    <span>Logout</span>
                                </button>
                            </form>
                        @else
                            <a href="{{ route('login') }}" class="dropdown-item btn-mobile-only">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M11 7L9.6 8.4l2.6 2.6H2v2h10.2l-2.6 2.6L11 17l5-5-5-5zm9 12h-8v2h8c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2h-8v2h8v14z"/>
                                </svg>
                                <span>Masuk</span>
                            </a>
                            <a href="{{ route('register') }}" class="dropdown-item btn-mobile-only">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M15 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm-9-2V7H4v3H1v2h3v3h2v-3h3v-2H6zm9 4c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                                </svg>
                                <span>Daftar</span>
                            </a>
                        @endauth
                    </div>
                </div>
            </div>
        </div>
    </nav>
</header>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const allAppsBtn = document.getElementById('allAppsBtn');
    const allAppsDropdown = document.getElementById('allAppsDropdown');
    
    allAppsBtn.addEventListener('click', function(e) {
        e.stopPropagation();
        allAppsDropdown.classList.toggle('show');
    });
    
    // Close dropdown when clicking outside
    document.addEventListener('click', function(e) {
        if (!allAppsBtn.contains(e.target) && !allAppsDropdown.contains(e.target)) {
            allAppsDropdown.classList.remove('show');
        }
    });
});
</script>
