<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>RISTOPUP - Game Store Terpercaya</title>
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/home.css') }}?v={{ time() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@12/swiper-bundle.min.css">
</head>
<body>
    @include('layouts.header')

    <div class="container">

        <!-- Main Content -->
        <main class="main-content">
            <!-- Success Message -->
            @if(session('success'))
            <div class="alert-success-banner">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                    <polyline points="22 4 12 14.01 9 11.01"/>
                </svg>
                <span>{{ session('success') }}</span>
            </div>
            @endif

            <!-- Hero Banner Slider -->
            <div class="swiper banner-swiper">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <img src="{{ asset('images/bannerpm1.jpg') }}" alt="Banner Promosi 1">
                    </div>
                    <div class="swiper-slide">
                        <img src="{{ asset('images/bannerpm2.webp') }}" alt="Banner Promosi 2">
                    </div>
                    <div class="swiper-slide">
                        <img src="{{ asset('images/bannerpm1.jpg') }}" alt="Banner Promosi 3">
                    </div>
                </div>
                
                <!-- Navigation Arrows -->
                <div class="swiper-button-prev"></div>
                <div class="swiper-button-next"></div>
                
                <!-- Pagination Dots -->
                <div class="swiper-pagination"></div>
            </div>

            <!-- Flash Sale Section on Homepage -->
            @if($activeFlashSales->count() > 0)
            <section class="flash-sale-home-section">
                <div class="section-header">
                    <div class="flash-sale-header-title">
                        <svg class="flash-icon-small" viewBox="0 0 24 24" fill="currentColor">
                            <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/>
                        </svg>
                        <h2>Flash Sale</h2>
                        <span class="live-badge">LIVE</span>
                    </div>
                    <a href="{{ route('flash-sale') }}" class="see-more">Lihat Semua</a>
                </div>
                <div class="flash-sale-home-grid">
                    @foreach($activeFlashSales as $flashSale)
                    <a href="{{ route('products.show', $flashSale->product->game->slug) }}" class="flash-sale-home-card">
                        <div class="flash-discount-badge">-{{ $flashSale->getDiscountPercentage() }}%</div>
                        <div class="flash-home-image">
                            <img src="{{ asset('storage/' . $flashSale->product->game->image) }}" alt="{{ $flashSale->product->name }}">
                        </div>
                        <div class="flash-home-info">
                            <span class="flash-home-game">{{ $flashSale->product->game->name }}</span>
                            <h4 class="flash-home-product">{{ $flashSale->product->name }}</h4>
                            <div class="flash-home-price">
                                <span class="original">Rp {{ number_format($flashSale->product->price, 0, ',', '.') }}</span>
                                <span class="sale">Rp {{ number_format($flashSale->flash_price, 0, ',', '.') }}</span>
                            </div>
                            <div class="flash-home-stock">
                                <div class="stock-bar">
                                    @php
                                        $stockPercentage = min(($flashSale->sold / $flashSale->flash_stock) * 100, 100);
                                    @endphp
                                    <div class="stock-fill" data-width="{{ $stockPercentage }}"></div>
                                </div>
                                <span class="stock-label">Sisa {{ $flashSale->getRemainingStock() }}</span>
                            </div>
                        </div>
                    </a>
                    @endforeach
                </div>
            </section>
            @endif

            <!-- Categories -->
            @if($categories->count() > 0)
            <section class="categories-section">
                <div class="section-header">
                    <h2>Kategori Game</h2>
                </div>
                <div class="categories-grid">
                    @foreach($categories as $category)
                    <a href="{{ route('category.show', $category->slug) }}" class="category-card">
                        <h3>{{ $category->name }}</h3>
                        <p>{{ $category->active_games_count }} Games</p>
                    </a>
                    @endforeach
                </div>
            </section>
            @endif

            <!-- Popular Games -->
            @if($popularGames->count() > 0)
            <section class="games-section">
                <div class="section-header">
                    <h2>Game Populer</h2>
                    <a href="#all-games" class="see-more">Lihat Semua</a>
                </div>
                <div class="popular-games-grid">
                    @foreach($popularGames as $game)
                    <a href="{{ route('products.show', $game->slug) }}" class="game-card">
                        <div class="game-image">
                            <img src="{{ asset('storage/' . $game->image) }}" alt="{{ $game->name }}" class="game-img-fallback" data-fallback="{{ asset('images/default-game.jpg') }}">
                        </div>
                        <div class="game-info">
                            <h3>{{ $game->name }}</h3>
                            <p class="game-category">{{ $game->category->name }}</p>
                            <div class="game-meta">
                                <span class="game-developer">{{ $game->developer }}</span>
                            </div>
                        </div>
                    </a>
                    @endforeach
                </div>
            </section>
            @endif

            <!-- All Games -->
            <section class="games-section" id="all-games">
                <div class="section-header">
                    <h2>Semua Game</h2>
                </div>
                <div class="all-games-grid">
                    @forelse($allGames as $game)
                    <a href="{{ route('products.show', $game->slug) }}" class="game-card">
                        <div class="game-image">
                            <img src="{{ asset('storage/' . $game->image) }}" alt="{{ $game->name }}" class="game-img-fallback" data-fallback="{{ asset('images/default-game.jpg') }}">
                            @if($game->is_popular)
                            <span class="game-badge">Popular</span>
                            @endif
                        </div>
                        <div class="game-info">
                            <h3>{{ $game->name }}</h3>
                            <p class="game-category">{{ $game->category->name }}</p>
                            <div class="game-meta">
                                <span class="game-developer">{{ $game->developer }}</span>
                            </div>
                        </div>
                    </a>
                    @empty
                    <div class="empty-state">
                        <p>Belum ada game tersedia. Silakan tambahkan game melalui admin panel.</p>
                    </div>
                    @endforelse
                </div>
            </section>
        </main>
    </div>

    @include('layouts.footer')

    <!-- JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@12/swiper-bundle.min.js"></script>
    <script src="{{ asset('js/app.js') }}"></script>
    
    <!-- Swiper Initialization -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Set stock progress bar widths from data attributes
            document.querySelectorAll('[data-width]').forEach(el => {
                el.style.width = el.dataset.width + '%';
            });
            
            const swiper = new Swiper('.banner-swiper', {
                loop: true,
                autoplay: {
                    delay: 4000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true,
                },
                speed: 600,
                effect: 'slide',
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                    dynamicBullets: false,
                },
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
            });

            // Handle image error fallback - only once per image
            document.querySelectorAll('.game-img-fallback').forEach(img => {
                img.addEventListener('error', function() {
                    if (!this.dataset.fallbackAttempted) {
                        this.dataset.fallbackAttempted = 'true';
                        this.src = this.dataset.fallback;
                    }
                }, { once: true });
            });
        });
    </script>
</body>
</html>
