<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $category->name }} - RISTOPUP</title>
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/home.css') }}?v={{ time() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    @include('layouts.header')

    <div class="container">
        <main class="main-content">
            <!-- Category Header -->
            <section class="category-header">
                <div class="category-header-content">
                    <div>
                        <h1>{{ $category->name }}</h1>
                        <p>{{ $games->count() }} Games Tersedia</p>
                    </div>
                </div>
                <a href="{{ route('home') }}" class="btn-back">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 12H5M12 19l-7-7 7-7"/>
                    </svg>
                    Kembali
                </a>
            </section>

            <!-- Games Grid -->
            <section class="games-section">
                @if($games->count() > 0)
                    <div class="games-grid">
                        @foreach($games as $game)
                        <a href="{{ route('products.show', $game->slug) }}" class="game-card">
                            <div class="game-image">
                                <img src="{{ asset('storage/' . $game->image) }}" alt="{{ $game->name }}" class="game-img-fallback" data-fallback="{{ asset('images/default-game.jpg') }}">
                                @if($game->is_popular)
                                <span class="game-badge">Popular</span>
                                @endif
                            </div>
                            <div class="game-info">
                                <h3>{{ $game->name }}</h3>
                                <p class="game-category">{{ $game->category->name }}</p>
                                <div class="game-meta">
                                    <span class="game-developer">{{ $game->developer }}</span>
                                </div>
                            </div>
                        </a>
                        @endforeach
                    </div>
                @else
                    <div class="empty-state">
                        <div class="empty-icon">🎮</div>
                        <h3>Belum Ada Game</h3>
                        <p>Kategori ini belum memiliki game. Silakan cek kategori lain atau kembali ke halaman utama.</p>
                        <a href="{{ route('home') }}" class="btn-primary">Kembali ke Home</a>
                    </div>
                @endif
            </section>
        </main>
    </div>

    @include('layouts.footer')

    <script src="{{ asset('js/app.js') }}"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Handle image error fallback - only once per image
            document.querySelectorAll('.game-img-fallback').forEach(img => {
                img.addEventListener('error', function() {
                    if (!this.dataset.fallbackAttempted) {
                        this.dataset.fallbackAttempted = 'true';
                        this.src = this.dataset.fallback;
                    }
                }, { once: true });
            });
        });
    </script>
</body>
</html>
