<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Flash Sale - RISTOPUP</title>
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/home.css') }}?v={{ time() }}">
    <link rel="stylesheet" href="{{ asset('css/flash-sale.css') }}?v={{ time() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    @include('layouts.header')

    <div class="container">
        <main class="main-content">
            <!-- Flash Sale Header -->
            <div class="flash-sale-header">
                <div class="flash-sale-title">
                    <svg class="flash-icon" viewBox="0 0 24 24" fill="currentColor">
                        <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/>
                    </svg>
                    <h1>Flash Sale</h1>
                </div>
                <p class="flash-sale-subtitle">Diskon terbatas, stok terbatas! Buruan sebelum kehabisan!</p>
            </div>

            <!-- Active Flash Sales -->
            @if($activeFlashSales->count() > 0)
            <section class="flash-sale-section">
                <div class="section-header">
                    <h2>
                        <span class="live-indicator"></span>
                        Sedang Berlangsung
                    </h2>
                </div>
                <div class="flash-sale-grid">
                    @foreach($activeFlashSales as $flashSale)
                    <div class="flash-sale-card" data-flash-id="{{ $flashSale->id }}" data-end-time="{{ $flashSale->end_time->timestamp }}">
                        <div class="flash-badge">
                            <svg viewBox="0 0 24 24" fill="currentColor">
                                <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/>
                            </svg>
                            -{{ $flashSale->getDiscountPercentage() }}%
                        </div>
                        
                        <a href="{{ route('products.show', $flashSale->product->game->slug) }}" class="flash-product-link">
                            <div class="flash-product-image">
                                <img src="{{ asset('storage/' . $flashSale->product->game->image) }}" alt="{{ $flashSale->product->name }}">
                            </div>
                            
                            <div class="flash-product-info">
                                <span class="flash-game-name">{{ $flashSale->product->game->name }}</span>
                                <h3 class="flash-product-name">{{ $flashSale->product->name }}</h3>
                                
                                <div class="flash-price-container">
                                    <span class="flash-original-price">Rp {{ number_format($flashSale->product->price, 0, ',', '.') }}</span>
                                    <span class="flash-sale-price">Rp {{ number_format($flashSale->flash_price, 0, ',', '.') }}</span>
                                </div>
                            </div>
                        </a>
                        
                        <div class="flash-stock-info">
                            <div class="stock-progress">
                                @php
                                    $stockPercentage = ($flashSale->sold / $flashSale->flash_stock) * 100;
                                @endphp
                                <div class="stock-progress-bar" data-width="{{ $stockPercentage }}"></div>
                            </div>
                            <div class="stock-text">
                                <span class="sold-text">Terjual {{ $flashSale->sold }}</span>
                                <span class="remaining-text">Sisa {{ $flashSale->getRemainingStock() }}</span>
                            </div>
                        </div>
                        
                        <div class="flash-countdown" data-countdown="{{ $flashSale->end_time->timestamp }}">
                            <div class="countdown-label">Berakhir dalam:</div>
                            <div class="countdown-timer">
                                <div class="countdown-unit">
                                    <span class="countdown-value hours">00</span>
                                    <span class="countdown-label-small">Jam</span>
                                </div>
                                <span class="countdown-separator">:</span>
                                <div class="countdown-unit">
                                    <span class="countdown-value minutes">00</span>
                                    <span class="countdown-label-small">Menit</span>
                                </div>
                                <span class="countdown-separator">:</span>
                                <div class="countdown-unit">
                                    <span class="countdown-value seconds">00</span>
                                    <span class="countdown-label-small">Detik</span>
                                </div>
                            </div>
                        </div>
                        
                        <a href="{{ route('products.show', $flashSale->product->game->slug) }}" class="flash-buy-btn">
                            Beli Sekarang
                        </a>
                    </div>
                    @endforeach
                </div>
            </section>
            @else
            <div class="no-flash-sale">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                    <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"/>
                </svg>
                <h3>Tidak Ada Flash Sale Aktif</h3>
                <p>Saat ini tidak ada flash sale yang sedang berlangsung. Cek lagi nanti!</p>
            </div>
            @endif

            <!-- Upcoming Flash Sales -->
            @if($upcomingFlashSales->count() > 0)
            <section class="flash-sale-section upcoming-section">
                <div class="section-header">
                    <h2>
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="10"/>
                            <polyline points="12 6 12 12 16 14"/>
                        </svg>
                        Akan Datang
                    </h2>
                </div>
                <div class="flash-sale-grid upcoming-grid">
                    @foreach($upcomingFlashSales as $flashSale)
                    <div class="flash-sale-card upcoming-card" data-flash-id="{{ $flashSale->id }}" data-start-time="{{ $flashSale->start_time->timestamp }}">
                        <div class="upcoming-badge">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <circle cx="12" cy="12" r="10"/>
                                <polyline points="12 6 12 12 16 14"/>
                            </svg>
                            Segera
                        </div>
                        
                        <div class="flash-product-image">
                            <img src="{{ asset('storage/' . $flashSale->product->game->image) }}" alt="{{ $flashSale->product->name }}">
                            <div class="upcoming-overlay">
                                <span>Mulai {{ $flashSale->start_time->format('d M H:i') }}</span>
                            </div>
                        </div>
                        
                        <div class="flash-product-info">
                            <span class="flash-game-name">{{ $flashSale->product->game->name }}</span>
                            <h3 class="flash-product-name">{{ $flashSale->product->name }}</h3>
                            
                            <div class="flash-price-container">
                                <span class="flash-original-price">Rp {{ number_format($flashSale->product->price, 0, ',', '.') }}</span>
                                <span class="flash-sale-price">Rp {{ number_format($flashSale->flash_price, 0, ',', '.') }}</span>
                                <span class="discount-badge">-{{ $flashSale->getDiscountPercentage() }}%</span>
                            </div>
                        </div>
                        
                        <div class="upcoming-countdown" data-countdown="{{ $flashSale->start_time->timestamp }}">
                            <div class="countdown-label">Dimulai dalam:</div>
                            <div class="countdown-timer">
                                <div class="countdown-unit">
                                    <span class="countdown-value hours">00</span>
                                    <span class="countdown-label-small">Jam</span>
                                </div>
                                <span class="countdown-separator">:</span>
                                <div class="countdown-unit">
                                    <span class="countdown-value minutes">00</span>
                                    <span class="countdown-label-small">Menit</span>
                                </div>
                                <span class="countdown-separator">:</span>
                                <div class="countdown-unit">
                                    <span class="countdown-value seconds">00</span>
                                    <span class="countdown-label-small">Detik</span>
                                </div>
                            </div>
                        </div>
                        
                        <button class="flash-notify-btn" disabled>
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"/>
                                <path d="M13.73 21a2 2 0 0 1-3.46 0"/>
                            </svg>
                            Ingatkan Saya
                        </button>
                    </div>
                    @endforeach
                </div>
            </section>
            @endif

        </main>
    </div>

    @include('layouts.footer')

    <script src="{{ asset('js/app.js') }}"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Set stock progress bar widths from data attributes
        document.querySelectorAll('[data-width]').forEach(el => {
            el.style.width = el.dataset.width + '%';
        });
        
        // Countdown Timer Function
        function updateCountdowns() {
            const now = Math.floor(Date.now() / 1000);
            
            // Active flash sales (counting down to end)
            document.querySelectorAll('.flash-countdown[data-countdown]').forEach(countdown => {
                const endTime = parseInt(countdown.dataset.countdown);
                const diff = endTime - now;
                
                if (diff <= 0) {
                    countdown.innerHTML = '<div class="countdown-ended">Flash Sale Berakhir!</div>';
                    const card = countdown.closest('.flash-sale-card');
                    if (card) {
                        card.classList.add('ended');
                    }
                    return;
                }
                
                const hours = Math.floor(diff / 3600);
                const minutes = Math.floor((diff % 3600) / 60);
                const seconds = diff % 60;
                
                countdown.querySelector('.hours').textContent = hours.toString().padStart(2, '0');
                countdown.querySelector('.minutes').textContent = minutes.toString().padStart(2, '0');
                countdown.querySelector('.seconds').textContent = seconds.toString().padStart(2, '0');
            });
            
            // Upcoming flash sales (counting down to start)
            document.querySelectorAll('.upcoming-countdown[data-countdown]').forEach(countdown => {
                const startTime = parseInt(countdown.dataset.countdown);
                const diff = startTime - now;
                
                if (diff <= 0) {
                    // Reload the page to show the flash sale as active
                    location.reload();
                    return;
                }
                
                const hours = Math.floor(diff / 3600);
                const minutes = Math.floor((diff % 3600) / 60);
                const seconds = diff % 60;
                
                countdown.querySelector('.hours').textContent = hours.toString().padStart(2, '0');
                countdown.querySelector('.minutes').textContent = minutes.toString().padStart(2, '0');
                countdown.querySelector('.seconds').textContent = seconds.toString().padStart(2, '0');
            });
        }
        
        // Initial update
        updateCountdowns();
        
        // Update every second
        setInterval(updateCountdowns, 1000);
    });
    </script>
</body>
</html>
