<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kode Verifikasi - RISTOPUP</title>
</head>
<body style="margin: 0; padding: 0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background-color: #0f172a;">
    <table role="presentation" width="100%" cellspacing="0" cellpadding="0" style="background-color: #0f172a; padding: 40px 20px;">
        <tr>
            <td align="center">
                <table role="presentation" width="100%" cellspacing="0" cellpadding="0" style="max-width: 480px; background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%); border-radius: 16px; border: 1px solid rgba(34, 197, 94, 0.2); overflow: hidden;">
                    <!-- Header with Logo -->
                    <tr>
                        <td style="padding: 32px 32px 24px; text-align: center; border-bottom: 1px solid rgba(255, 255, 255, 0.1);">
                            <div style="display: inline-block; background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%); padding: 12px 24px; border-radius: 8px;">
                                <span style="font-size: 24px; font-weight: 800; color: white; letter-spacing: 1px;">RISTOPUP</span>
                            </div>
                        </td>
                    </tr>
                    
                    <!-- Main Content -->
                    <tr>
                        <td style="padding: 32px;">
                            <!-- Title -->
                            <h1 style="margin: 0 0 8px; font-size: 22px; font-weight: 700; color: #ffffff; text-align: center;">
                                Kode Verifikasi Email
                            </h1>
                            <p style="margin: 0 0 28px; font-size: 14px; color: #94a3b8; text-align: center;">
                                Gunakan kode berikut untuk menyelesaikan pendaftaran
                            </p>
                            
                            <!-- Code Box -->
                            <div style="background: linear-gradient(135deg, rgba(34, 197, 94, 0.15) 0%, rgba(34, 197, 94, 0.05) 100%); border: 2px solid #22c55e; border-radius: 12px; padding: 24px; text-align: center; margin-bottom: 24px;">
                                <span style="font-size: 36px; font-weight: 800; letter-spacing: 8px; color: #22c55e; font-family: 'Courier New', monospace;">{{ $code }}</span>
                            </div>
                            
                            <!-- Timer Warning -->
                            <div style="display: flex; align-items: center; justify-content: center; background-color: rgba(251, 191, 36, 0.1); border-radius: 8px; padding: 12px 16px; margin-bottom: 24px;">
                                <table role="presentation" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td style="padding-right: 10px;">
                                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <circle cx="12" cy="12" r="10" stroke="#fbbf24" stroke-width="2"/>
                                                <path d="M12 6v6l4 2" stroke="#fbbf24" stroke-width="2" stroke-linecap="round"/>
                                            </svg>
                                        </td>
                                        <td>
                                            <span style="font-size: 13px; color: #fbbf24; font-weight: 500;">Kode ini berlaku selama 5 menit</span>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            
                            <!-- Info Text -->
                            <p style="margin: 0; font-size: 13px; color: #64748b; text-align: center; line-height: 1.6;">
                                Jika Anda tidak merasa mendaftar di RISTOPUP,<br>abaikan email ini.
                            </p>
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td style="padding: 20px 32px; background-color: rgba(0, 0, 0, 0.2); border-top: 1px solid rgba(255, 255, 255, 0.1);">
                            <p style="margin: 0; font-size: 12px; color: #475569; text-align: center;">
                                © {{ date('Y') }} RISTOPUP. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
                
                <!-- Bottom Text -->
                <p style="margin: 24px 0 0; font-size: 11px; color: #475569; text-align: center;">
                    Email ini dikirim secara otomatis. Mohon tidak membalas email ini.
                </p>
            </td>
        </tr>
    </table>
</body>
</html>
