<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password - {{ config('app.name') }}</title>
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link rel="stylesheet" href="{{ asset('css/auth.css') }}">
    <style>
        .password-strength {
            margin-top: 8px;
            height: 4px;
            background: #e5e7eb;
            border-radius: 2px;
            overflow: hidden;
        }
        
        .password-strength-bar {
            height: 100%;
            width: 0%;
            transition: all 0.3s ease;
        }
        
        .password-strength-bar.weak {
            width: 33%;
            background: #ef4444;
        }
        
        .password-strength-bar.medium {
            width: 66%;
            background: #f59e0b;
        }
        
        .password-strength-bar.strong {
            width: 100%;
            background: #109F2C;
        }
        
        .password-hint {
            font-size: 12px;
            color: #6b7280;
            margin-top: 8px;
        }
        
        .password-requirements {
            margin-top: 10px;
            padding: 12px;
            background: #f9fafb;
            border-radius: 6px;
            font-size: 12px;
        }
        
        .requirement {
            display: flex;
            align-items: center;
            gap: 8px;
            margin: 4px 0;
            color: #6b7280;
        }
        
        .requirement.met {
            color: #109F2C;
        }
        
        .requirement svg {
            width: 16px;
            height: 16px;
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <div class="auth-left">
            <div class="auth-brand">
                <div class="brand-logo">𝓶</div>
                <h1>Gaming Platform</h1>
                <p>Join thousands of gamers worldwide</p>
            </div>
            <div class="auth-illustration">
                <div class="game-icon">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <line x1="6" y1="12" x2="10" y2="12"/>
                        <line x1="8" y1="10" x2="8" y2="14"/>
                        <line x1="15" y1="11" x2="15" y2="11.01"/>
                        <line x1="18" y1="13" x2="18" y2="13.01"/>
                        <rect x="2" y="6" width="20" height="12" rx="2"/>
                    </svg>
                </div>
                <div class="game-icon">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <circle cx="12" cy="12" r="6"/>
                        <circle cx="12" cy="12" r="2"/>
                    </svg>
                </div>
                <div class="game-icon">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                        <path d="M2 17l10 5 10-5M2 12l10 5 10-5"/>
                    </svg>
                </div>
                <div class="game-icon">⭐</div>
            </div>
        </div>

        <div class="auth-right">
            <div class="auth-card">
                <div class="auth-header">
                    <h2>Reset Password</h2>
                    <p>Masukkan password baru Anda yang aman dan mudah diingat</p>
                </div>

                @if ($errors->any())
                    <div class="alert alert-error">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form method="POST" action="{{ route('password.update') }}" class="auth-form" id="resetPasswordForm">
                    @csrf

                    <input type="hidden" name="token" value="{{ $token }}">
                    <input type="hidden" name="email" value="{{ $email }}">

                    <div class="form-group">
                        <label for="email">Email</label>
                        <div class="input-wrapper">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                                <polyline points="22,6 12,13 2,6"/>
                            </svg>
                            <input type="email" 
                                   id="email" 
                                   name="email" 
                                   value="{{ $email }}" 
                                   readonly
                                   style="background-color: #f5f5f5; cursor: not-allowed;">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password">Password Baru</label>
                        <div class="input-wrapper">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"/>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"/>
                            </svg>
                            <input type="password" 
                                   id="password" 
                                   name="password" 
                                   required 
                                   autofocus
                                   placeholder="Minimal 8 karakter"
                                   oninput="checkPasswordStrength()">
                        </div>
                        <div class="password-strength">
                            <div class="password-strength-bar" id="strengthBar"></div>
                        </div>
                        <div class="password-hint" id="strengthText"></div>
                        
                        <div class="password-requirements">
                            <div class="requirement" id="req-length">
                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                </svg>
                                <span>Minimal 8 karakter</span>
                            </div>
                            <div class="requirement" id="req-letter">
                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                </svg>
                                <span>Minimal 1 huruf</span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password_confirmation">Konfirmasi Password</label>
                        <div class="input-wrapper">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"/>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"/>
                            </svg>
                            <input type="password" 
                                   id="password_confirmation" 
                                   name="password_confirmation" 
                                   required
                                   placeholder="Ulangi password baru"
                                   oninput="checkPasswordMatch()">
                        </div>
                        <div class="password-hint" id="matchText"></div>
                    </div>

                    <button type="submit" class="btn-primary" id="submitBtn">
                        Reset Password
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                        </svg>
                    </button>
                </form>

                <div class="auth-footer">
                    <p><a href="{{ route('login') }}">← Kembali ke Login</a></p>
                </div>
            </div>
        </div>
    </div>

    <script>
        function checkPasswordStrength() {
            const password = document.getElementById('password').value;
            const strengthBar = document.getElementById('strengthBar');
            const strengthText = document.getElementById('strengthText');
            const reqLength = document.getElementById('req-length');
            const reqLetter = document.getElementById('req-letter');
            
            // Check requirements
            const hasLength = password.length >= 8;
            const hasLetter = /[a-zA-Z]/.test(password);
            
            // Update requirement indicators
            updateRequirement(reqLength, hasLength);
            updateRequirement(reqLetter, hasLetter);
            
            // Calculate strength
            let strength = 0;
            if (hasLength) strength++;
            if (hasLetter) strength++;
            if (/[0-9]/.test(password)) strength++;
            if (/[^a-zA-Z0-9]/.test(password)) strength++;
            
            // Update strength bar
            strengthBar.className = 'password-strength-bar';
            if (strength <= 2) {
                strengthBar.classList.add('weak');
                strengthText.textContent = 'Password lemah';
                strengthText.style.color = '#ef4444';
            } else if (strength === 3) {
                strengthBar.classList.add('medium');
                strengthText.textContent = 'Password sedang';
                strengthText.style.color = '#f59e0b';
            } else {
                strengthBar.classList.add('strong');
                strengthText.textContent = 'Password kuat';
                strengthText.style.color = '#109F2C';
            }
            
            checkPasswordMatch();
        }
        
        function updateRequirement(element, met) {
            const svg = element.querySelector('svg');
            if (met) {
                element.classList.add('met');
                svg.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>';
            } else {
                element.classList.remove('met');
                svg.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>';
            }
        }
        
        function checkPasswordMatch() {
            const password = document.getElementById('password').value;
            const confirmation = document.getElementById('password_confirmation').value;
            const matchText = document.getElementById('matchText');
            const submitBtn = document.getElementById('submitBtn');
            
            if (confirmation.length === 0) {
                matchText.textContent = '';
                return;
            }
            
            if (password === confirmation) {
                matchText.textContent = '✓ Password cocok';
                matchText.style.color = '#109F2C';
                submitBtn.disabled = false;
            } else {
                matchText.textContent = '✗ Password tidak cocok';
                matchText.style.color = '#ef4444';
                submitBtn.disabled = true;
            }
        }
    </script>
</body>
</html>
