<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>RISTOPUP - Daftar</title>
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/auth.css') }}?v={{ time() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    <div class="auth-container">
        <div class="auth-left">
            <div class="auth-illustration">
                <img src="{{ asset('images/background.jpg') }}" alt="Delta Force Soldier">
            </div>
        </div>
        
        <div class="auth-right">
            <div class="auth-card">
                <div class="auth-logo">
                    <img src="{{ asset('images/GIF_20260105_080206_513.gif') }}?v={{ time() }}" alt="Logo" style="animation: none;">
                </div>
                
                <div class="auth-header">
                    <h2>Buat Akun</h2>
                    <p>Bergabung Sekarang</p>
                </div>

                @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
                @endif

                @if($errors->any())
                <div class="alert alert-error">
                    <ul>
                        @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                <form action="{{ route('register') }}" method="POST" class="auth-form">
                    @csrf
                    
                    <!-- Row 1: Username & Nomor Telepon -->
                    <div class="form-row">
                        <div class="form-group">
                            <label for="name">Username</label>
                            <div class="input-wrapper">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                                    <circle cx="12" cy="7" r="4"/>
                                </svg>
                                <input type="text" id="name" name="name" value="{{ old('name') }}" placeholder="Masukan Username" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="phone">Nomor Telepon</label>
                            <div class="input-wrapper">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
                                </svg>
                                <input type="tel" id="phone" name="phone" value="{{ old('phone') }}" placeholder="Masukan Nomor Telepon" required>
                            </div>
                        </div>
                    </div>

                    <!-- Row 2: Email & Kode Verifikasi -->
                    <div class="form-row">
                        <div class="form-group">
                            <label for="email">Alamat Email</label>
                            <div class="input-wrapper">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                                    <polyline points="22,6 12,13 2,6"/>
                                </svg>
                                <input type="email" id="email" name="email" value="{{ old('email') }}" placeholder="Masukan Alamat email" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="verification_code">Kode Verifikasi</label>
                            <div class="input-wrapper verification-input-wrapper">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                                    <path d="M2 17l10 5 10-5"/>
                                    <path d="M2 12l10 5 10-5"/>
                                </svg>
                                <input type="text" id="verification_code" name="verification_code" placeholder="Masukan Kode" maxlength="6" required disabled>
                                <button type="button" class="btn-action-inside" id="actionCodeBtn" data-action="send" disabled>
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" id="btnIcon">
                                        <path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Row 3: Password & Retype Password -->
                    <div class="form-row">
                        <div class="form-group">
                            <label for="password">Kata Sandi</label>
                            <div class="input-wrapper">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <rect x="3" y="11" width="18" height="11" rx="2" ry="2"/>
                                    <path d="M7 11V7a5 5 0 0 1 10 0v4"/>
                                </svg>
                                <input type="password" id="password" name="password" placeholder="Buat Kata Sandi" required>
                                <button type="button" class="toggle-password" data-target="password">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                                        <circle cx="12" cy="12" r="3"/>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="password_confirmation">Konfirmasi Kata Sandi</label>
                            <div class="input-wrapper">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <rect x="3" y="11" width="18" height="11" rx="2" ry="2"/>
                                    <path d="M7 11V7a5 5 0 0 1 10 0v4"/>
                                </svg>
                                <input type="password" id="password_confirmation" name="password_confirmation" placeholder="Tulis Kembali Kata Sandi" required>
                                <button type="button" class="toggle-password" data-target="password_confirmation">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                                        <circle cx="12" cy="12" r="3"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="form-options">
                        <label class="checkbox-label terms-checkbox">
                            <input type="checkbox" name="terms" id="terms" {{ old('terms') ? 'checked' : '' }} required>
                            <span>Saya setuju dengan <a href="{{ route('terms') }}" target="_blank">Syarat & Ketentuan</a></span>
                        </label>
                    </div>

                    <button type="submit" class="btn-primary" id="register-btn">
                        Buat Akun
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"/>
                        </svg>
                    </button>
                </form>

                <div class="auth-footer">
                    <p>Sudah punya akun? <a href="{{ route('login') }}">Masuk</a></p>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/animejs@3.2.2/lib/anime.min.js"></script>
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="{{ asset('js/auth.js') }}"></script>
    <script>
        // Variables
        const emailInput = document.getElementById('email');
        const sendCodeBtn = document.getElementById('sendCodeBtn');
        const verifyCodeBtn = document.getElementById('verifyCodeBtn');
        const verificationCodeInput = document.getElementById('verification_code');
        const termsCheckbox = document.getElementById('terms');
        const registerBtn = document.getElementById('register-btn');
        const form = document.querySelector('.auth-form');
        
        let countdown;
        let codeVerified = false;
        let codeSent = false;
        let countdownActive = false;

        // Toggle password visibility
        document.querySelectorAll('.toggle-password').forEach(button => {
            button.addEventListener('click', function() {
                const targetId = this.getAttribute('data-target');
                const input = document.getElementById(targetId);
                const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
                input.setAttribute('type', type);
                
                // Toggle icon
                const svg = this.querySelector('svg');
                if (type === 'text') {
                    svg.innerHTML = '<path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"/><line x1="1" y1="1" x2="23" y2="23"/>';
                } else {
                    svg.innerHTML = '<path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/><circle cx="12" cy="12" r="3"/>';
                }
            });
        });

        // Handle input on verification code
        verificationCodeInput.addEventListener('input', function() {
            if (countdownActive) {
                if (this.value.length > 0) {
                    // User typing, show verify icon
                    actionCodeBtn.setAttribute('data-action', 'verify');
                    actionCodeBtn.disabled = false;
                    actionCodeBtn.classList.add('active');
                    btnIcon.innerHTML = '<polyline points="20 6 9 17 4 12"/>';
                    btnIcon.setAttribute('fill', 'none');
                    btnIcon.setAttribute('stroke', 'currentColor');
                    btnIcon.setAttribute('stroke-width', '2');
                    this.disabled = false;
                } else {
                    // Input empty, show timer again
                    actionCodeBtn.setAttribute('data-action', 'send');
                    actionCodeBtn.disabled = true;
                    actionCodeBtn.classList.remove('active');
                    btnIcon.innerHTML = '<path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>';
                    btnIcon.setAttribute('fill', 'currentColor');
                    btnIcon.removeAttribute('stroke');
                    btnIcon.removeAttribute('stroke-width');
                }
            }
        });

        // Enable send button when email is valid
        emailInput.addEventListener('input', function() {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (emailRegex.test(this.value) && !codeSent) {
                actionCodeBtn.disabled = false;
                actionCodeBtn.classList.add('active');
            } else if (!codeSent) {
                actionCodeBtn.disabled = true;
                actionCodeBtn.classList.remove('active');
            }
        });

        // Action button click handler (Send or Verify)
        actionCodeBtn.addEventListener('click', async function() {
            const action = this.getAttribute('data-action');
            
            if (action === 'send') {
                await sendVerificationCode();
            } else if (action === 'verify') {
                await verifyCode();
            }
        });

        // Send verification code
        async function sendVerificationCode() {
            const email = emailInput.value;
            
            if (!email) {
                alert('Masukan email terlebih dahulu');
                return;
            }

            actionCodeBtn.disabled = true;
            btnIcon.innerHTML = '<span class="spinner"></span>';

            try {
                const response = await fetch('{{ route("send.verification.code") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({ email: email })
                });

                const data = await response.json();

                if (response.ok) {
                    codeSent = true;
                    verificationCodeInput.disabled = false;
                    verificationCodeInput.placeholder = '';
                    verificationCodeInput.focus();
                    
                    // Change button to verify mode
                    actionCodeBtn.setAttribute('data-action', 'verify');
                    actionCodeBtn.disabled = false;
                    actionCodeBtn.classList.add('active');
                    btnIcon.innerHTML = '<polyline points="20 6 9 17 4 12"/>';
                    btnIcon.setAttribute('fill', 'none');
                    btnIcon.setAttribute('stroke', 'currentColor');
                    btnIcon.setAttribute('stroke-width', '2');
                    
                    startCountdown(60);
                    alert(data.message);
                } else {
                    alert(data.message || 'Gagal mengirim kode verifikasi');
                    resetSendButton();
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Terjadi kesalahan. Silakan coba lagi.');
                resetSendButton();
            }
        }

        function resetSendButton() {
            actionCodeBtn.disabled = false;
            actionCodeBtn.classList.add('active');
            btnIcon.innerHTML = '<path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>';
            btnIcon.setAttribute('fill', 'currentColor');
            btnIcon.removeAttribute('stroke');
            btnIcon.removeAttribute('stroke-width');
        }

        // Start countdown timer
        function startCountdown(seconds) {
            let timeLeft = seconds;
            countdownActive = true;
            
            // Set initial timer in input if empty
            if (verificationCodeInput.value.length === 0) {
                verificationCodeInput.placeholder = `${timeLeft}s`;
                actionCodeBtn.disabled = true;
                actionCodeBtn.classList.remove('active');
            }
            
            countdown = setInterval(() => {
                timeLeft--;
                
                // Only update placeholder if input is empty
                if (verificationCodeInput.value.length === 0) {
                    verificationCodeInput.placeholder = `${timeLeft}s`;
                }
                
                if (timeLeft <= 0) {
                    clearInterval(countdown);
                    countdownActive = false;
                    codeSent = false;
                    
                    if (verificationCodeInput.value.length === 0) {
                        verificationCodeInput.placeholder = 'Kirim ulang kode';
                        actionCodeBtn.setAttribute('data-action', 'send');
                        actionCodeBtn.disabled = false;
                        actionCodeBtn.classList.add('active');
                        resetSendButton();
                    }
                }
            }, 1000);
        }

        // Verify code
        async function verifyCode() {
            const email = emailInput.value;
            const code = verificationCodeInput.value;

            if (!code || code.length !== 6) {
                alert('Masukan 6 digit kode verifikasi');
                verificationCodeInput.focus();
                return;
            }

            actionCodeBtn.disabled = true;
            btnIcon.innerHTML = '<span class="spinner"></span>';

            try {
                const response = await fetch('{{ route("verify.code") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({ email: email, code: code })
                });

                const data = await response.json();

                if (response.ok) {
                    codeVerified = true;
                    verificationCodeInput.style.borderColor = '#10b981';
                    verificationCodeInput.disabled = true;
                    actionCodeBtn.disabled = true;
                    actionCodeBtn.classList.remove('active');
                    actionCodeBtn.setAttribute('data-status', 'success');
                    btnIcon.innerHTML = '<path d="M1.73 12.91l6.37 6.37L22.79 4.59"/><path d="M8.1 19.28L1.73 12.91"/>';
                    btnIcon.setAttribute('fill', 'none');
                    btnIcon.setAttribute('stroke', '#10b981');
                    btnIcon.setAttribute('stroke-width', '2.5');
                    btnIcon.setAttribute('stroke-linecap', 'round');
                    btnIcon.setAttribute('stroke-linejoin', 'round');
                    countdownActive = false;
                    clearInterval(countdown);
                } else {
                    codeVerified = false;
                    verificationCodeInput.style.borderColor = '#ef4444';
                    verificationCodeInput.value = '';
                    verificationCodeInput.focus();
                    actionCodeBtn.disabled = true;
                    actionCodeBtn.classList.remove('active');
                    actionCodeBtn.setAttribute('data-status', 'error');
                    btnIcon.innerHTML = '<line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/>';
                    btnIcon.setAttribute('fill', 'none');
                    btnIcon.setAttribute('stroke', '#ef4444');
                    btnIcon.setAttribute('stroke-width', '2.5');
                    btnIcon.setAttribute('stroke-linecap', 'round');
                    
                    // Reset to verify mode after 2 seconds
                    setTimeout(() => {
                        verificationCodeInput.style.borderColor = 'rgba(255, 255, 255, 0.2)';
                        actionCodeBtn.disabled = false;
                        actionCodeBtn.classList.add('active');
                        actionCodeBtn.setAttribute('data-status', '');
                        btnIcon.innerHTML = '<polyline points="20 6 9 17 4 12"/>';
                        btnIcon.setAttribute('stroke', 'currentColor');
                        btnIcon.setAttribute('stroke-width', '2');
                        btnIcon.removeAttribute('stroke-linecap');
                        btnIcon.removeAttribute('stroke-linejoin');
                    }, 2000);
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Terjadi kesalahan. Silakan coba lagi.');
                // Reset to verify mode
                actionCodeBtn.disabled = false;
                actionCodeBtn.classList.add('active');
                btnIcon.innerHTML = '<polyline points="20 6 9 17 4 12"/>';
                btnIcon.setAttribute('fill', 'none');
                btnIcon.setAttribute('stroke', 'currentColor');
                btnIcon.setAttribute('stroke-width', '2');
            }
        }

        // Validasi checkbox Terms & Conditions
        function updateButtonState() {
            if (termsCheckbox.checked) {
                registerBtn.style.opacity = '1';
                registerBtn.style.cursor = 'pointer';
                registerBtn.disabled = false;
            } else {
                registerBtn.style.opacity = '0.5';
                registerBtn.style.cursor = 'not-allowed';
                registerBtn.disabled = true;
            }
        }

        termsCheckbox.addEventListener('change', updateButtonState);
        updateButtonState();

        // Form validation
        form.addEventListener('submit', function(e) {
            if (!termsCheckbox.checked) {
                e.preventDefault();
                alert('Tolong setujui syarat dan ketentuan dahulu');
                return false;
            }

            if (!codeVerified) {
                e.preventDefault();
                alert('Silakan verifikasi email Anda terlebih dahulu');
                verificationCodeInput.focus();
                return false;
            }
        });
    </script>
</body>
</html>
