<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Lupa Password - WebTopUp</title>
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/auth.css') }}?v={{ time() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        .send-method {
            margin-bottom: 20px;
            padding: 0;
            background: transparent;
            border-radius: 8px;
        }
        
        .send-method-title {
            font-size: 14px;
            font-weight: 600;
            color: #FEFFFF;
            margin-bottom: 12px;
        }
        
        .method-options {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        
        .method-option {
            display: flex;
            align-items: center;
            padding: 12px;
            background: white;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .method-option:hover {
            border-color: var(--color-primary);
            background: #f0fdf4;
        }
        
        .method-option input[type="radio"] {
            width: 20px;
            height: 20px;
            margin-right: 12px;
            cursor: pointer;
            accent-color: var(--color-primary);
        }
        
        .method-option.selected {
            border-color: var(--color-primary);
            background: #f0fdf4;
        }
        
        .method-info {
            flex: 1;
        }
        
        .method-name {
            font-weight: 600;
            color: #1f2937;
            font-size: 15px;
            margin-bottom: 2px;
        }
        
        .method-desc {
            font-size: 12px;
            color: #6b7280;
        }
        
        .method-icon {
            font-size: 24px;
            margin-left: 10px;
        }
        
        .form-group label svg {
            vertical-align: middle;
        }
        
        .btn-primary svg {
            vertical-align: middle;
        }
        
        .info-box {
            padding: 12px;
            background: #eff6ff;
            border-left: 4px solid #3b82f6;
            border-radius: 4px;
            margin-bottom: 20px;
            font-size: 13px;
            color: #1e40af;
        }
        
        .info-box svg {
            display: inline-block;
            width: 16px;
            height: 16px;
            margin-right: 8px;
            vertical-align: middle;
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <div class="auth-left">
            <div class="auth-illustration">
                <img src="{{ asset('images/background.jpg') }}" alt="Delta Force Soldier">
            </div>
        </div>

        <div class="auth-right">
            <div class="auth-card">
                <div class="auth-header">
                    <h2>Lupa Password</h2>
                    <p>Masukkan email dan pilih metode pengiriman untuk reset password Anda.</p>
                </div>

                @if (session('status'))
                    <div class="alert alert-success">
                        {{ session('status') }}
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-error">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form method="POST" action="{{ route('password.email') }}" class="auth-form" id="forgotPasswordForm">
                    @csrf

                    <div class="send-method">
                        <div class="send-method-title">Pilih Metode Pengiriman:</div>
                        <div class="method-options">
                            <label class="method-option selected">
                                <input type="radio" name="send_method" value="email" checked onchange="toggleInputField()">
                                <div class="method-info">
                                    <div class="method-name">Email</div>
                                    <div class="method-desc">Link dikirim ke email Anda</div>
                                </div>
                                <div class="method-icon">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                                        <polyline points="22,6 12,13 2,6"/>
                                    </svg>
                                </div>
                            </label>

                            <label class="method-option">
                                <input type="radio" name="send_method" value="whatsapp" onchange="toggleInputField()">
                                <div class="method-info">
                                    <div class="method-name">WhatsApp</div>
                                    <div class="method-desc">Link dikirim ke WhatsApp Anda</div>
                                </div>
                                <div class="method-icon">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
                                    </svg>
                                </div>
                            </label>
                        </div>
                    </div>

                    <!-- Dynamic Input Field -->
                    <div class="form-group" id="emailField">
                        <label for="email">Email Address</label>
                        <div class="input-wrapper">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                                <polyline points="22,6 12,13 2,6"/>
                            </svg>
                            <input type="email" 
                                   id="email" 
                                   name="email" 
                                   value="{{ old('email') }}" 
                                   required 
                                   autofocus
                                   placeholder="nama@example.com">
                        </div>
                    </div>

                    <div class="form-group" id="phoneField" style="display: none;">
                        <label for="phone">Nomor WhatsApp</label>
                        <div class="input-wrapper">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
                            </svg>
                            <input type="text" 
                                   id="phone" 
                                   name="phone" 
                                   value="{{ old('phone') }}"
                                   placeholder="Contoh: 08123456789">
                        </div>
                    </div>

                    <button type="submit" class="btn-primary">
                        Kirim Link Reset Password
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>
                        </svg>
                    </button>
                </form>

                <div class="auth-footer">
                    <p><a href="{{ route('login') }}">← Kembali ke Login</a></p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Toggle input field based on selected method
        function toggleInputField() {
            const selectedMethod = document.querySelector('input[name="send_method"]:checked').value;
            const emailField = document.getElementById('emailField');
            const phoneField = document.getElementById('phoneField');
            const emailInput = document.getElementById('email');
            const phoneInput = document.getElementById('phone');
            
            if (selectedMethod === 'email') {
                emailField.style.display = 'block';
                phoneField.style.display = 'none';
                emailInput.required = true;
                phoneInput.required = false;
                emailInput.focus();
            } else {
                emailField.style.display = 'none';
                phoneField.style.display = 'block';
                emailInput.required = false;
                phoneInput.required = true;
                phoneInput.focus();
            }
        }

        // Handle method option styling
        document.querySelectorAll('.method-option').forEach(option => {
            option.addEventListener('click', function() {
                document.querySelectorAll('.method-option').forEach(opt => {
                    opt.classList.remove('selected');
                });
                this.classList.add('selected');
            });
        });

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            toggleInputField();
        });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/animejs@3.2.2/lib/anime.min.js"></script>
    <script src="{{ asset('js/auth.js') }}"></script>
</body>
</html>
