@extends('admin.layout')

@section('title', 'Products')
@section('page-title', 'Products')

@section('header-actions')
    <a href="{{ route('admin.products.create') }}" class="btn btn-primary">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <line x1="12" y1="5" x2="12" y2="19"></line>
            <line x1="5" y1="12" x2="19" y2="12"></line>
        </svg>
        Add Product
    </a>
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        @if($products->count() > 0)
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th data-sortable>Product Name</th>
                            <th>Game</th>
                            <th>Price</th>
                            <th>Discount</th>
                            <th>Stock</th>
                            <th data-sortable>Sort Order</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($products as $product)
                            <tr>
                                <td>
                                    <strong>{{ $product->name }}</strong>
                                    @if($product->description)
                                        <br><small style="color: var(--admin-text-secondary);">{{ Str::limit($product->description, 50) }}</small>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge badge-secondary">{{ $product->game->name }}</span>
                                </td>
                                <td>
                                    <strong>Rp {{ number_format($product->price, 0, ',', '.') }}</strong>
                                    @if($product->hasDiscount())
                                        <br><small style="color: var(--admin-text-secondary); text-decoration: line-through;">Rp {{ number_format($product->original_price, 0, ',', '.') }}</small>
                                    @endif
                                </td>
                                <td>
                                    @if($product->hasDiscount())
                                        <span class="badge badge-warning">-{{ $product->getDiscountPercentage() }}%</span>
                                    @else
                                        <span class="badge badge-secondary">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($product->stock !== null)
                                        @if($product->stock > 0)
                                            <span class="badge badge-success">{{ $product->stock }}</span>
                                        @else
                                            <span class="badge badge-danger">Out of Stock</span>
                                        @endif
                                    @else
                                        <span class="badge badge-info">Unlimited</span>
                                    @endif
                                </td>
                                <td>{{ $product->sort_order }}</td>
                                <td>
                                    @if($product->is_active)
                                        <span class="badge badge-success">Active</span>
                                    @else
                                        <span class="badge badge-danger">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <a href="{{ route('admin.products.edit', $product) }}" class="btn btn-sm btn-secondary" title="Edit">
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <path d="M11 4H4a2 2 0 00-2 2v14a2 2 0 002 2h14a2 2 0 002-2v-7"></path>
                                                <path d="M18.5 2.5a2.121 2.121 0 013 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                                            </svg>
                                        </a>
                                        <form action="{{ route('admin.products.destroy', $product) }}" method="POST" class="delete-form" data-item-name="{{ $product->name }}" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                    <polyline points="3 6 5 6 21 6"></polyline>
                                                    <path d="M19 6v14a2 2 0 01-2 2H7a2 2 0 01-2-2V6m3 0V4a2 2 0 012-2h4a2 2 0 012 2v2"></path>
                                                    <line x1="10" y1="11" x2="10" y2="17"></line>
                                                    <line x1="14" y1="11" x2="14" y2="17"></line>
                                                </svg>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="empty-state">
                <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1">
                    <circle cx="9" cy="21" r="1"></circle>
                    <circle cx="20" cy="21" r="1"></circle>
                    <path d="M1 1h4l2.68 13.39a2 2 0 002 1.61h9.72a2 2 0 002-1.61L23 6H6"></path>
                </svg>
                <h3>No Products Yet</h3>
                <p>Start by adding your first product to the store.</p>
                <a href="{{ route('admin.products.create') }}" class="btn btn-primary">Add First Product</a>
            </div>
        @endif
    </div>
</div>
@endsection
