@extends('admin.layout')

@section('title', 'Create Product')
@section('page-title', 'Add New Product')

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.products.store') }}" method="POST" data-validate>
            @csrf

            <div class="form-grid">
                <div class="form-group">
                    <label for="game_id" class="form-label required">Game</label>
                    <select id="game_id" name="game_id" class="form-select" required>
                        <option value="">Select a game</option>
                        @foreach($games as $game)
                            <option value="{{ $game->id }}" {{ old('game_id') == $game->id ? 'selected' : '' }}>
                                {{ $game->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="name" class="form-label required">Product Name</label>
                    <input type="text" id="name" name="name" class="form-input" value="{{ old('name') }}" required placeholder="e.g., 100 Diamonds">
                </div>

                <div class="form-group">
                    <label for="description" class="form-label">Description</label>
                    <textarea id="description" name="description" class="form-textarea" placeholder="Optional product description">{{ old('description') }}</textarea>
                </div>

                <div class="form-group">
                    <label for="price" class="form-label required">Price (Rp)</label>
                    <input type="number" id="price" name="price" class="form-input" value="{{ old('price') }}" required min="0" step="1" placeholder="25000">
                </div>

                <div class="form-group">
                    <label for="original_price" class="form-label">Original Price (Rp)</label>
                    <input type="number" id="original_price" name="original_price" class="form-input" value="{{ old('original_price') }}" min="0" step="1" placeholder="30000">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Leave empty if no discount. If set, must be higher than price.</small>
                </div>

                <div class="form-group">
                    <label for="stock" class="form-label">Stock</label>
                    <input type="number" id="stock" name="stock" class="form-input" value="{{ old('stock') }}" min="0" step="1" placeholder="100">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Leave empty for unlimited stock</small>
                </div>

                <div class="form-group">
                    <label for="sort_order" class="form-label">Sort Order</label>
                    <input type="number" id="sort_order" name="sort_order" class="form-input" value="{{ old('sort_order', 0) }}" min="0">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Lower numbers appear first</small>
                </div>

                <div class="form-group">
                    <div class="checkbox-group">
                        <input type="checkbox" id="is_active" name="is_active" class="form-checkbox" {{ old('is_active', true) ? 'checked' : '' }}>
                        <label for="is_active" class="checkbox-label">Active (visible on website)</label>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <a href="{{ route('admin.products.index') }}" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 21H5a2 2 0 01-2-2V5a2 2 0 012-2h11l5 5v11a2 2 0 01-2 2z"></path>
                        <polyline points="17 21 17 13 7 13 7 21"></polyline>
                        <polyline points="7 3 7 8 15 8"></polyline>
                    </svg>
                    Create Product
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
