@extends('layouts.admin')

@section('title', 'Detail Pesanan - ' . $order->order_id)

@section('content')
<div class="admin-header">
    <div class="header-left">
        <a href="{{ route('admin.orders.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
        <h1>Detail Pesanan</h1>
    </div>
    <div class="header-right">
        <span class="order-id-display">{{ $order->order_id }}</span>
    </div>
</div>

@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

<div class="order-detail-grid">
    <!-- Main Info -->
    <div class="order-main">
        <!-- Status Card -->
        <div class="detail-card status-card">
            <div class="current-status">
                <span class="status-badge status-{{ $order->status }} large">
                    {{ $order->getStatusLabel() }}
                </span>
                @if($order->status === 'pending' && $order->isExpired())
                    <span class="expired-badge">Expired</span>
                @endif
            </div>
            
            <form action="{{ route('admin.orders.update-status', $order) }}" method="POST" class="status-form">
                @csrf
                @method('PATCH')
                <div class="form-group">
                    <label>Update Status</label>
                    <select name="status" class="form-control">
                        <option value="pending" {{ $order->status === 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="paid" {{ $order->status === 'paid' ? 'selected' : '' }}>Dibayar</option>
                        <option value="processing" {{ $order->status === 'processing' ? 'selected' : '' }}>Diproses</option>
                        <option value="completed" {{ $order->status === 'completed' ? 'selected' : '' }}>Selesai</option>
                        <option value="failed" {{ $order->status === 'failed' ? 'selected' : '' }}>Gagal</option>
                        <option value="refunded" {{ $order->status === 'refunded' ? 'selected' : '' }}>Refund</option>
                        <option value="expired" {{ $order->status === 'expired' ? 'selected' : '' }}>Expired</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Catatan Admin</label>
                    <textarea name="admin_notes" class="form-control" rows="3" placeholder="Catatan internal...">{{ $order->admin_notes }}</textarea>
                </div>
                <button type="submit" class="btn btn-primary btn-block">
                    <i class="fas fa-save"></i> Simpan Perubahan
                </button>
            </form>
        </div>

        <!-- Product Info -->
        <div class="detail-card">
            <h3><i class="fas fa-box"></i> Informasi Produk</h3>
            <div class="product-detail">
                @if($order->product)
                    <div class="product-row">
                        <span class="label">Produk</span>
                        <span class="value">{{ $order->product->name }}</span>
                    </div>
                    <div class="product-row">
                        <span class="label">Game</span>
                        <span class="value">{{ $order->product->game->name ?? '-' }}</span>
                    </div>
                @else
                    <p class="text-muted">Produk telah dihapus</p>
                @endif
                
                @if($order->flashSale)
                    <div class="flash-sale-info">
                        <span class="flash-icon">⚡</span>
                        <span>Flash Sale: {{ $order->flashSale->name }}</span>
                    </div>
                @endif
            </div>
        </div>

        <!-- Customer Info -->
        <div class="detail-card">
            <h3><i class="fas fa-user"></i> Informasi Pelanggan</h3>
            <div class="customer-detail">
                <div class="info-row">
                    <span class="label">ID Game</span>
                    <span class="value copyable" data-copy="{{ $order->game_user_id }}">
                        {{ $order->game_user_id }}
                        <i class="fas fa-copy copy-icon"></i>
                    </span>
                </div>
                <div class="info-row">
                    <span class="label">WhatsApp</span>
                    <span class="value">
                        <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $order->whatsapp) }}" 
                           target="_blank" class="wa-link">
                            {{ $order->whatsapp }}
                            <i class="fab fa-whatsapp"></i>
                        </a>
                    </span>
                </div>
                @if($order->email)
                <div class="info-row">
                    <span class="label">Email</span>
                    <span class="value">{{ $order->email }}</span>
                </div>
                @endif
            </div>
        </div>

        <!-- Payment Info -->
        <div class="detail-card">
            <h3><i class="fas fa-credit-card"></i> Informasi Pembayaran</h3>
            <div class="payment-detail">
                <div class="info-row">
                    <span class="label">Metode Pembayaran</span>
                    <span class="value">{{ $order->payment_method ?? 'Belum dipilih' }}</span>
                </div>
                <div class="info-row">
                    <span class="label">Harga Asli</span>
                    <span class="value">Rp {{ number_format($order->original_price, 0, ',', '.') }}</span>
                </div>
                @if($order->discount_amount > 0)
                <div class="info-row">
                    <span class="label">Diskon</span>
                    <span class="value discount">- Rp {{ number_format($order->discount_amount, 0, ',', '.') }}</span>
                </div>
                @endif
                <div class="info-row total">
                    <span class="label">Total Bayar</span>
                    <span class="value">Rp {{ number_format($order->final_price, 0, ',', '.') }}</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="order-sidebar">
        <!-- Timeline -->
        <div class="detail-card">
            <h3><i class="fas fa-history"></i> Timeline</h3>
            <div class="order-timeline">
                <div class="timeline-item completed">
                    <div class="timeline-dot"></div>
                    <div class="timeline-content">
                        <span class="timeline-title">Pesanan Dibuat</span>
                        <span class="timeline-time">{{ $order->created_at->format('d M Y, H:i') }}</span>
                    </div>
                </div>
                
                @if($order->paid_at)
                <div class="timeline-item completed">
                    <div class="timeline-dot"></div>
                    <div class="timeline-content">
                        <span class="timeline-title">Pembayaran Diterima</span>
                        <span class="timeline-time">{{ $order->paid_at->format('d M Y, H:i') }}</span>
                    </div>
                </div>
                @endif
                
                @if($order->completed_at)
                <div class="timeline-item completed">
                    <div class="timeline-dot"></div>
                    <div class="timeline-content">
                        <span class="timeline-title">Pesanan Selesai</span>
                        <span class="timeline-time">{{ $order->completed_at->format('d M Y, H:i') }}</span>
                    </div>
                </div>
                @endif
                
                @if($order->status === 'pending' && !$order->isExpired())
                <div class="timeline-item pending">
                    <div class="timeline-dot"></div>
                    <div class="timeline-content">
                        <span class="timeline-title">Menunggu Pembayaran</span>
                        <span class="timeline-time">Batas: {{ $order->expires_at->format('d M Y, H:i') }}</span>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="detail-card">
            <h3><i class="fas fa-bolt"></i> Quick Actions</h3>
            <div class="quick-actions">
                <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $order->whatsapp) }}?text={{ urlencode('Halo! Pesanan Anda dengan Order ID: ' . $order->order_id . ' sedang kami proses.') }}" 
                   target="_blank" class="btn btn-success btn-block">
                    <i class="fab fa-whatsapp"></i> Hubungi via WhatsApp
                </a>
                
                <a href="{{ route('order.status', $order->order_id) }}" target="_blank" class="btn btn-info btn-block">
                    <i class="fas fa-external-link-alt"></i> Lihat Halaman Status
                </a>
                
                <form action="{{ route('admin.orders.destroy', $order) }}" method="POST" 
                      onsubmit="return confirm('Yakin ingin menghapus pesanan ini? Aksi ini tidak dapat dibatalkan.')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-block">
                        <i class="fas fa-trash"></i> Hapus Pesanan
                    </button>
                </form>
            </div>
        </div>

        <!-- Order Meta -->
        <div class="detail-card">
            <h3><i class="fas fa-info-circle"></i> Informasi Lain</h3>
            <div class="meta-info">
                <div class="meta-row">
                    <span class="label">IP Address</span>
                    <span class="value">{{ $order->ip_address ?? '-' }}</span>
                </div>
                <div class="meta-row">
                    <span class="label">Terakhir Diupdate</span>
                    <span class="value">{{ $order->updated_at->format('d M Y, H:i') }}</span>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.admin-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.header-left h1 {
    margin: 0;
}

.order-id-display {
    font-family: monospace;
    font-size: 1.25rem;
    font-weight: 600;
    color: var(--primary-color);
    background: var(--card-bg);
    padding: 0.5rem 1rem;
    border-radius: 8px;
    border: 1px solid var(--border-color);
}

.order-detail-grid {
    display: grid;
    grid-template-columns: 1fr 350px;
    gap: 1.5rem;
}

@media (max-width: 1024px) {
    .order-detail-grid {
        grid-template-columns: 1fr;
    }
}

.detail-card {
    background: var(--card-bg);
    border-radius: 12px;
    padding: 1.5rem;
    border: 1px solid var(--border-color);
    margin-bottom: 1.5rem;
}

.detail-card h3 {
    font-size: 1rem;
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 1px solid var(--border-color);
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.detail-card h3 i {
    color: var(--primary-color);
}

.status-card {
    background: linear-gradient(135deg, var(--card-bg) 0%, rgba(var(--primary-rgb), 0.05) 100%);
}

.current-status {
    text-align: center;
    margin-bottom: 1.5rem;
}

.status-badge.large {
    font-size: 1rem;
    padding: 0.75rem 1.5rem;
}

.expired-badge {
    display: inline-block;
    background: #e74c3c;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 12px;
    font-size: 0.75rem;
    margin-left: 0.5rem;
}

.status-form .form-group {
    margin-bottom: 1rem;
}

.status-form label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
    color: var(--text-secondary);
}

.status-form .form-control {
    width: 100%;
    padding: 0.75rem;
    border: 1px solid var(--border-color);
    border-radius: 8px;
    background: var(--background);
    color: var(--text-primary);
}

.info-row, .product-row, .meta-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    border-bottom: 1px solid var(--border-color);
}

.info-row:last-child, .product-row:last-child, .meta-row:last-child {
    border-bottom: none;
}

.info-row .label, .product-row .label, .meta-row .label {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

.info-row .value, .product-row .value, .meta-row .value {
    font-weight: 500;
    color: var(--text-primary);
}

.info-row.total {
    background: var(--background);
    margin: 0.5rem -1.5rem -1.5rem;
    padding: 1rem 1.5rem;
    border-radius: 0 0 12px 12px;
}

.info-row.total .value {
    font-size: 1.25rem;
    color: var(--primary-color);
}

.discount {
    color: #27ae60 !important;
}

.flash-sale-info {
    background: linear-gradient(135deg, #ff6b35, #f7931e);
    color: white;
    padding: 0.75rem 1rem;
    border-radius: 8px;
    margin-top: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.copyable {
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.copyable:hover {
    color: var(--primary-color);
}

.copy-icon {
    font-size: 0.8rem;
    opacity: 0.5;
}

.wa-link {
    color: #25d366;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.wa-link:hover {
    text-decoration: underline;
}

.order-timeline {
    position: relative;
    padding-left: 1.5rem;
}

.timeline-item {
    position: relative;
    padding-bottom: 1.5rem;
    padding-left: 1rem;
}

.timeline-item:last-child {
    padding-bottom: 0;
}

.timeline-item::before {
    content: '';
    position: absolute;
    left: -1.5rem;
    top: 0.5rem;
    bottom: 0;
    width: 2px;
    background: var(--border-color);
}

.timeline-item:last-child::before {
    display: none;
}

.timeline-dot {
    position: absolute;
    left: -1.75rem;
    top: 0.25rem;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: var(--border-color);
    border: 2px solid var(--card-bg);
}

.timeline-item.completed .timeline-dot {
    background: #27ae60;
}

.timeline-item.pending .timeline-dot {
    background: #f39c12;
}

.timeline-content {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.timeline-title {
    font-weight: 500;
    color: var(--text-primary);
}

.timeline-time {
    font-size: 0.8rem;
    color: var(--text-secondary);
}

.quick-actions {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.btn-block {
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
}

.status-badge {
    display: inline-block;
    padding: 0.35rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 500;
}

.status-pending { background: #fff3cd; color: #856404; }
.status-paid { background: #cce5ff; color: #004085; }
.status-processing { background: #d4edda; color: #155724; }
.status-completed { background: #28a745; color: white; }
.status-failed { background: #f8d7da; color: #721c24; }
.status-expired { background: #6c757d; color: white; }
.status-refunded { background: #e2e3e5; color: #383d41; }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Copy functionality
    document.querySelectorAll('.copyable').forEach(el => {
        el.addEventListener('click', function() {
            const text = this.dataset.copy;
            navigator.clipboard.writeText(text).then(() => {
                const icon = this.querySelector('.copy-icon');
                icon.className = 'fas fa-check copy-icon';
                setTimeout(() => {
                    icon.className = 'fas fa-copy copy-icon';
                }, 2000);
            });
        });
    });
});
</script>
@endsection
