@extends('admin.layout')

@section('title', 'Games')
@section('page-title', 'Games')

@section('header-actions')
    <a href="{{ route('admin.games.create') }}" class="btn btn-primary">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <line x1="12" y1="5" x2="12" y2="19"></line>
            <line x1="5" y1="12" x2="19" y2="12"></line>
        </svg>
        Add Game
    </a>
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        @if($games->count() > 0)
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th data-sortable>Name</th>
                            <th>Category</th>
                            <th>Developer</th>
                            <th data-sortable>Sort Order</th>
                            <th>Status</th>
                            <th>Popular</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($games as $game)
                            <tr>
                                <td>
                                    <img src="{{ asset('storage/' . $game->image) }}" alt="{{ $game->name }}" class="table-img">
                                </td>
                                <td>
                                    <strong>{{ $game->name }}</strong>
                                    <br>
                                    <small style="color: var(--admin-text-secondary);">{{ $game->slug }}</small>
                                </td>
                                <td>
                                    <span class="badge badge-secondary">{{ $game->category->name }}</span>
                                </td>
                                <td>{{ $game->developer ?? '-' }}</td>
                                <td>{{ $game->sort_order }}</td>
                                <td>
                                    @if($game->is_active)
                                        <span class="badge badge-success">Active</span>
                                    @else
                                        <span class="badge badge-danger">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    @if($game->is_popular)
                                        <span class="badge badge-warning">Popular</span>
                                    @else
                                        <span class="badge badge-secondary">-</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <a href="{{ route('admin.games.edit', $game) }}" class="btn btn-sm btn-secondary" title="Edit">
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <path d="M11 4H4a2 2 0 00-2 2v14a2 2 0 002 2h14a2 2 0 002-2v-7"></path>
                                                <path d="M18.5 2.5a2.121 2.121 0 013 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                                            </svg>
                                        </a>
                                        <a href="{{ route('products.show', $game) }}" class="btn btn-sm btn-info" title="View on Website" target="_blank">
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                                <circle cx="12" cy="12" r="3"></circle>
                                            </svg>
                                        </a>
                                        <form action="{{ route('admin.games.destroy', $game) }}" method="POST" class="delete-form" data-item-name="{{ $game->name }}" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                    <polyline points="3 6 5 6 21 6"></polyline>
                                                    <path d="M19 6v14a2 2 0 01-2 2H7a2 2 0 01-2-2V6m3 0V4a2 2 0 012-2h4a2 2 0 012 2v2"></path>
                                                    <line x1="10" y1="11" x2="10" y2="17"></line>
                                                    <line x1="14" y1="11" x2="14" y2="17"></line>
                                                </svg>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="empty-state">
                <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1">
                    <path d="M6 2L3 6v14a2 2 0 002 2h14a2 2 0 002-2V6l-3-4z"></path>
                    <line x1="3" y1="6" x2="21" y2="6"></line>
                    <path d="M16 10a4 4 0 01-8 0"></path>
                </svg>
                <h3>No Games Yet</h3>
                <p>Start by adding your first game to the store.</p>
                <a href="{{ route('admin.games.create') }}" class="btn btn-primary">Add First Game</a>
            </div>
        @endif
    </div>
</div>
@endsection
