@extends('admin.layout')

@section('title', 'Create Game')
@section('page-title', 'Add New Game')

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.games.store') }}" method="POST" enctype="multipart/form-data" data-validate>
            @csrf

            <div class="form-grid">
                <div class="form-group">
                    <label for="category_id" class="form-label required">Category</label>
                    <select id="category_id" name="category_id" class="form-select" required>
                        <option value="">Select a category</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="name" class="form-label required">Game Name</label>
                    <input type="text" id="name" name="name" class="form-input" value="{{ old('name') }}" required data-slug-source="slug" placeholder="e.g., Mobile Legends">
                </div>

                <div class="form-group">
                    <label for="slug" class="form-label required">Slug (URL-friendly name)</label>
                    <input type="text" id="slug" name="slug" class="form-input" value="{{ old('slug') }}" required placeholder="e.g., mobile-legends">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Auto-generated from name</small>
                </div>

                <div class="form-group">
                    <label for="image" class="form-label required">Game Image</label>
                    <input type="file" id="image" name="image" class="form-file" accept="image/*" required>
                    <div class="file-upload-area">
                        <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="file-upload-icon">
                            <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                            <circle cx="8.5" cy="8.5" r="1.5"></circle>
                            <polyline points="21 15 16 10 5 21"></polyline>
                        </svg>
                        <div class="file-upload-text">Click to upload or drag and drop</div>
                        <div class="file-upload-hint">PNG, JPG, WEBP up to 2MB</div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="developer" class="form-label">Developer</label>
                    <input type="text" id="developer" name="developer" class="form-input" value="{{ old('developer') }}" placeholder="e.g., Moonton">
                </div>

                <div class="form-group">
                    <label for="description" class="form-label">Description</label>
                    <textarea id="description" name="description" class="form-textarea" placeholder="Brief description of the game">{{ old('description') }}</textarea>
                </div>

                <div class="form-group">
                    <label for="sort_order" class="form-label">Sort Order</label>
                    <input type="number" id="sort_order" name="sort_order" class="form-input" value="{{ old('sort_order', 0) }}" min="0">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Lower numbers appear first</small>
                </div>

                <div class="form-group">
                    <div class="checkbox-group">
                        <input type="checkbox" id="is_popular" name="is_popular" class="form-checkbox" {{ old('is_popular') ? 'checked' : '' }}>
                        <label for="is_popular" class="checkbox-label">Mark as Popular (featured on homepage)</label>
                    </div>
                </div>

                <div class="form-group">
                    <div class="checkbox-group">
                        <input type="checkbox" id="is_active" name="is_active" class="form-checkbox" {{ old('is_active', true) ? 'checked' : '' }}>
                        <label for="is_active" class="checkbox-label">Active (visible on website)</label>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <a href="{{ route('admin.games.index') }}" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 21H5a2 2 0 01-2-2V5a2 2 0 012-2h11l5 5v11a2 2 0 01-2 2z"></path>
                        <polyline points="17 21 17 13 7 13 7 21"></polyline>
                        <polyline points="7 3 7 8 15 8"></polyline>
                    </svg>
                    Create Game
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
