@extends('admin.layout')

@section('title', 'Flash Sales')
@section('page-title', 'Flash Sales')

@section('header-actions')
    <a href="{{ route('admin.flash-sales.create') }}" class="btn btn-primary">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <line x1="12" y1="5" x2="12" y2="19"></line>
            <line x1="5" y1="12" x2="19" y2="12"></line>
        </svg>
        Tambah Flash Sale
    </a>
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        @if($flashSales->count() > 0)
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Produk</th>
                            <th>Game</th>
                            <th>Harga Normal</th>
                            <th>Harga Flash Sale</th>
                            <th>Diskon</th>
                            <th>Stok</th>
                            <th>Terjual</th>
                            <th>Waktu</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($flashSales as $flashSale)
                            <tr>
                                <td>
                                    <strong>{{ $flashSale->product->name }}</strong>
                                </td>
                                <td>
                                    <span class="badge badge-secondary">{{ $flashSale->product->game->name }}</span>
                                </td>
                                <td>
                                    <span style="text-decoration: line-through; color: var(--admin-text-secondary);">
                                        Rp {{ number_format($flashSale->product->price, 0, ',', '.') }}
                                    </span>
                                </td>
                                <td>
                                    <strong style="color: var(--admin-danger);">Rp {{ number_format($flashSale->flash_price, 0, ',', '.') }}</strong>
                                </td>
                                <td>
                                    <span class="badge badge-warning">-{{ $flashSale->getDiscountPercentage() }}%</span>
                                </td>
                                <td>
                                    <span class="badge {{ $flashSale->getRemainingStock() > 0 ? 'badge-success' : 'badge-danger' }}">
                                        {{ $flashSale->getRemainingStock() }} / {{ $flashSale->flash_stock }}
                                    </span>
                                </td>
                                <td>{{ $flashSale->sold }}</td>
                                <td>
                                    <small>
                                        <strong>Mulai:</strong> {{ $flashSale->start_time->format('d M Y H:i') }}<br>
                                        <strong>Berakhir:</strong> {{ $flashSale->end_time->format('d M Y H:i') }}
                                    </small>
                                </td>
                                <td>
                                    <span class="badge badge-{{ $flashSale->getStatusClass() }}">
                                        {{ $flashSale->getStatusLabel() }}
                                    </span>
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <a href="{{ route('admin.flash-sales.edit', $flashSale) }}" class="btn btn-sm btn-secondary" title="Edit">
                                            <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                <path d="M11 4H4a2 2 0 00-2 2v14a2 2 0 002 2h14a2 2 0 002-2v-7"></path>
                                                <path d="M18.5 2.5a2.121 2.121 0 013 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                                            </svg>
                                        </a>
                                        <form action="{{ route('admin.flash-sales.destroy', $flashSale) }}" method="POST" class="delete-form" data-item-name="Flash Sale {{ $flashSale->product->name }}" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" title="Hapus">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                    <polyline points="3 6 5 6 21 6"></polyline>
                                                    <path d="M19 6v14a2 2 0 01-2 2H7a2 2 0 01-2-2V6m3 0V4a2 2 0 012-2h4a2 2 0 012 2v2"></path>
                                                    <line x1="10" y1="11" x2="10" y2="17"></line>
                                                    <line x1="14" y1="11" x2="14" y2="17"></line>
                                                </svg>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="empty-state">
                <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1">
                    <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"></polygon>
                </svg>
                <h3>Belum Ada Flash Sale</h3>
                <p>Buat flash sale pertama untuk menarik pembeli.</p>
                <a href="{{ route('admin.flash-sales.create') }}" class="btn btn-primary">Buat Flash Sale</a>
            </div>
        @endif
    </div>
</div>
@endsection
