@extends('admin.layout')

@section('title', 'Edit Flash Sale')
@section('page-title', 'Edit Flash Sale')

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.flash-sales.update', $flashSale) }}" method="POST" data-validate>
            @csrf
            @method('PUT')

            <div class="form-grid">
                <div class="form-group">
                    <label for="product_id" class="form-label required">Pilih Produk</label>
                    <select id="product_id" name="product_id" class="form-select" required onchange="updateProductInfo()">
                        <option value="">-- Pilih Produk --</option>
                        @foreach($products as $product)
                            <option value="{{ $product->id }}" 
                                data-price="{{ $product->price }}"
                                data-game="{{ $product->game->name }}"
                                {{ old('product_id', $flashSale->product_id) == $product->id ? 'selected' : '' }}>
                                {{ $product->game->name }} - {{ $product->name }} (Rp {{ number_format($product->price, 0, ',', '.') }})
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label">Info Produk</label>
                    <div id="product-info" class="product-info-box">
                        <p style="color: var(--admin-text-secondary);">Pilih produk terlebih dahulu</p>
                    </div>
                </div>

                <div class="form-group">
                    <label for="flash_price" class="form-label required">Harga Flash Sale (Rp)</label>
                    <input type="number" id="flash_price" name="flash_price" class="form-input" value="{{ old('flash_price', $flashSale->flash_price) }}" required min="0" step="1" placeholder="Masukkan harga flash sale">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Harga khusus selama flash sale berlangsung</small>
                </div>

                <div class="form-group">
                    <label for="flash_stock" class="form-label required">Stok Flash Sale</label>
                    <input type="number" id="flash_stock" name="flash_stock" class="form-input" value="{{ old('flash_stock', $flashSale->flash_stock) }}" required min="1" step="1" placeholder="Jumlah stok untuk flash sale">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Jumlah stok yang dialokasikan untuk flash sale ini. Sudah terjual: {{ $flashSale->sold }}</small>
                </div>

                <div class="form-group">
                    <label for="start_time" class="form-label required">Waktu Mulai</label>
                    <input type="datetime-local" id="start_time" name="start_time" class="form-input" value="{{ old('start_time', $flashSale->start_time->format('Y-m-d\TH:i')) }}" required>
                </div>

                <div class="form-group">
                    <label for="end_time" class="form-label required">Waktu Berakhir</label>
                    <input type="datetime-local" id="end_time" name="end_time" class="form-input" value="{{ old('end_time', $flashSale->end_time->format('Y-m-d\TH:i')) }}" required>
                </div>

                <div class="form-group">
                    <label class="form-label">Status Saat Ini</label>
                    <div>
                        <span class="badge badge-{{ $flashSale->getStatusClass() }}" style="font-size: 0.9rem; padding: 0.5rem 1rem;">
                            {{ $flashSale->getStatusLabel() }}
                        </span>
                        <span style="margin-left: 1rem; color: var(--admin-text-secondary);">
                            Sisa stok: {{ $flashSale->getRemainingStock() }} | Terjual: {{ $flashSale->sold }}
                        </span>
                    </div>
                </div>

                <div class="form-group">
                    <div class="checkbox-group">
                        <input type="checkbox" id="is_active" name="is_active" class="form-checkbox" {{ old('is_active', $flashSale->is_active) ? 'checked' : '' }}>
                        <label for="is_active" class="checkbox-label">Aktif (Flash sale akan terlihat sesuai jadwal)</label>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <a href="{{ route('admin.flash-sales.index') }}" class="btn btn-secondary">Batal</a>
                <button type="submit" class="btn btn-primary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 21H5a2 2 0 01-2-2V5a2 2 0 012-2h11l5 5v11a2 2 0 01-2 2z"></path>
                        <polyline points="17 21 17 13 7 13 7 21"></polyline>
                        <polyline points="7 3 7 8 15 8"></polyline>
                    </svg>
                    Update Flash Sale
                </button>
            </div>
        </form>
    </div>
</div>

<style>
.product-info-box {
    background: var(--admin-bg-light);
    border: 1px solid var(--admin-border);
    border-radius: 8px;
    padding: 1rem;
    min-height: 60px;
}
.product-info-box .info-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 0.5rem;
}
.product-info-box .info-row:last-child {
    margin-bottom: 0;
}
.product-info-box .info-label {
    color: var(--admin-text-secondary);
}
.product-info-box .info-value {
    font-weight: 600;
}
</style>

<script>
function updateProductInfo() {
    const select = document.getElementById('product_id');
    const infoBox = document.getElementById('product-info');
    const selectedOption = select.options[select.selectedIndex];
    
    if (selectedOption.value) {
        const price = selectedOption.dataset.price;
        const game = selectedOption.dataset.game;
        const productName = selectedOption.text.split(' - ')[1]?.split(' (')[0] || '';
        
        infoBox.innerHTML = `
            <div class="info-row">
                <span class="info-label">Game:</span>
                <span class="info-value">${game}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Produk:</span>
                <span class="info-value">${productName}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Harga Normal:</span>
                <span class="info-value">Rp ${parseInt(price).toLocaleString('id-ID')}</span>
            </div>
        `;
    } else {
        infoBox.innerHTML = '<p style="color: var(--admin-text-secondary);">Pilih produk terlebih dahulu</p>';
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    updateProductInfo();
});
</script>
@endsection
