@extends('admin.layout')

@section('title', 'Tambah Flash Sale')
@section('page-title', 'Tambah Flash Sale Baru')

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.flash-sales.store') }}" method="POST" data-validate>
            @csrf

            <div class="form-grid">
                <div class="form-group">
                    <label for="product_id" class="form-label required">Pilih Produk</label>
                    <select id="product_id" name="product_id" class="form-select" required onchange="updateProductInfo()">
                        <option value="">-- Pilih Produk --</option>
                        @foreach($products as $product)
                            <option value="{{ $product->id }}" 
                                data-price="{{ $product->price }}"
                                data-game="{{ $product->game->name }}"
                                {{ old('product_id') == $product->id ? 'selected' : '' }}>
                                {{ $product->game->name }} - {{ $product->name }} (Rp {{ number_format($product->price, 0, ',', '.') }})
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label">Info Produk</label>
                    <div id="product-info" class="product-info-box">
                        <p style="color: var(--admin-text-secondary);">Pilih produk terlebih dahulu</p>
                    </div>
                </div>

                <div class="form-group">
                    <label for="flash_price" class="form-label required">Harga Flash Sale (Rp)</label>
                    <input type="number" id="flash_price" name="flash_price" class="form-input" value="{{ old('flash_price') }}" required min="0" step="1" placeholder="Masukkan harga flash sale">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Harga khusus selama flash sale berlangsung</small>
                </div>

                <div class="form-group">
                    <label for="flash_stock" class="form-label required">Stok Flash Sale</label>
                    <input type="number" id="flash_stock" name="flash_stock" class="form-input" value="{{ old('flash_stock') }}" required min="1" step="1" placeholder="Jumlah stok untuk flash sale">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Jumlah stok yang dialokasikan untuk flash sale ini</small>
                </div>

                <div class="form-group">
                    <label for="start_time" class="form-label required">Waktu Mulai</label>
                    <input type="datetime-local" id="start_time" name="start_time" class="form-input" value="{{ old('start_time') }}" required>
                </div>

                <div class="form-group">
                    <label for="end_time" class="form-label required">Waktu Berakhir</label>
                    <input type="datetime-local" id="end_time" name="end_time" class="form-input" value="{{ old('end_time') }}" required>
                </div>

                <div class="form-group">
                    <div class="checkbox-group">
                        <input type="checkbox" id="is_active" name="is_active" class="form-checkbox" {{ old('is_active', true) ? 'checked' : '' }}>
                        <label for="is_active" class="checkbox-label">Aktif (Flash sale akan terlihat sesuai jadwal)</label>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <a href="{{ route('admin.flash-sales.index') }}" class="btn btn-secondary">Batal</a>
                <button type="submit" class="btn btn-primary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"></polygon>
                    </svg>
                    Buat Flash Sale
                </button>
            </div>
        </form>
    </div>
</div>

<style>
.product-info-box {
    background: var(--admin-bg-light);
    border: 1px solid var(--admin-border);
    border-radius: 8px;
    padding: 1rem;
    min-height: 60px;
}
.product-info-box .info-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 0.5rem;
}
.product-info-box .info-row:last-child {
    margin-bottom: 0;
}
.product-info-box .info-label {
    color: var(--admin-text-secondary);
}
.product-info-box .info-value {
    font-weight: 600;
}
</style>

<script>
function updateProductInfo() {
    const select = document.getElementById('product_id');
    const infoBox = document.getElementById('product-info');
    const selectedOption = select.options[select.selectedIndex];
    
    if (selectedOption.value) {
        const price = selectedOption.dataset.price;
        const game = selectedOption.dataset.game;
        const productName = selectedOption.text.split(' - ')[1]?.split(' (')[0] || '';
        
        infoBox.innerHTML = `
            <div class="info-row">
                <span class="info-label">Game:</span>
                <span class="info-value">${game}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Produk:</span>
                <span class="info-value">${productName}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Harga Normal:</span>
                <span class="info-value">Rp ${parseInt(price).toLocaleString('id-ID')}</span>
            </div>
        `;
    } else {
        infoBox.innerHTML = '<p style="color: var(--admin-text-secondary);">Pilih produk terlebih dahulu</p>';
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    updateProductInfo();
});
</script>
@endsection
