@extends('admin.layout')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')

@section('content')
<div class="dashboard-grid">
    <!-- Stats Cards -->
    <div class="stats-container">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M4 6h16M4 12h16M4 18h16"></path>
                </svg>
            </div>
            <div class="stat-details">
                <h3 class="stat-value">{{ $stats['categories'] }}</h3>
                <p class="stat-label">Categories</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M6 2L3 6v14a2 2 0 002 2h14a2 2 0 002-2V6l-3-4z"></path>
                    <line x1="3" y1="6" x2="21" y2="6"></line>
                    <path d="M16 10a4 4 0 01-8 0"></path>
                </svg>
            </div>
            <div class="stat-details">
                <h3 class="stat-value">{{ $stats['games'] }}</h3>
                <p class="stat-label">Total Games</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <circle cx="9" cy="21" r="1"></circle>
                    <circle cx="20" cy="21" r="1"></circle>
                    <path d="M1 1h4l2.68 13.39a2 2 0 002 1.61h9.72a2 2 0 002-1.61L23 6H6"></path>
                </svg>
            </div>
            <div class="stat-details">
                <h3 class="stat-value">{{ $stats['products'] }}</h3>
                <p class="stat-label">Total Products</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #0C951E 0%, #06d62b 100%);">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <polyline points="22 12 18 12 15 21 9 3 6 12 2 12"></polyline>
                </svg>
            </div>
            <div class="stat-details">
                <h3 class="stat-value">{{ $stats['active_games'] }}</h3>
                <p class="stat-label">Active Games</p>
            </div>
        </div>
    </div>

    <!-- Recent Games -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Recent Games</h2>
            <a href="{{ route('admin.games.create') }}" class="btn btn-primary btn-sm">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="12" y1="5" x2="12" y2="19"></line>
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                </svg>
                Add New Game
            </a>
        </div>
        <div class="card-body">
            @if($recentGames->count() > 0)
                <div class="table-responsive">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>Image</th>
                                <th>Name</th>
                                <th>Category</th>
                                <th>Developer</th>
                                <th>Status</th>
                                <th>Popular</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($recentGames as $game)
                                <tr>
                                    <td>
                                        <img src="{{ asset('storage/' . $game->image) }}" alt="{{ $game->name }}" class="table-img">
                                    </td>
                                    <td><strong>{{ $game->name }}</strong></td>
                                    <td>
                                        <span class="badge badge-secondary">{{ $game->category->name }}</span>
                                    </td>
                                    <td>{{ $game->developer ?? '-' }}</td>
                                    <td>
                                        @if($game->is_active)
                                            <span class="badge badge-success">Active</span>
                                        @else
                                            <span class="badge badge-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($game->is_popular)
                                            <span class="badge badge-warning">Popular</span>
                                        @else
                                            <span class="badge badge-secondary">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <a href="{{ route('admin.games.edit', $game) }}" class="btn btn-sm btn-secondary" title="Edit">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                    <path d="M11 4H4a2 2 0 00-2 2v14a2 2 0 002 2h14a2 2 0 002-2v-7"></path>
                                                    <path d="M18.5 2.5a2.121 2.121 0 013 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                                                </svg>
                                            </a>
                                            <a href="{{ route('products.show', $game) }}" class="btn btn-sm btn-info" title="View" target="_blank">
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                                    <circle cx="12" cy="12" r="3"></circle>
                                                </svg>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="empty-state">
                    <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1">
                        <path d="M6 2L3 6v14a2 2 0 002 2h14a2 2 0 002-2V6l-3-4z"></path>
                        <line x1="3" y1="6" x2="21" y2="6"></line>
                        <path d="M16 10a4 4 0 01-8 0"></path>
                    </svg>
                    <h3>No Games Yet</h3>
                    <p>Start by adding your first game to the store.</p>
                    <a href="{{ route('admin.games.create') }}" class="btn btn-primary">Add Your First Game</a>
                </div>
            @endif
        </div>
    </div>

    <!-- Quick Links -->
    <div class="quick-links-grid">
        <a href="{{ route('admin.categories.create') }}" class="quick-link-card">
            <div class="quick-link-icon">
                <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="12" y1="5" x2="12" y2="19"></line>
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                </svg>
            </div>
            <h3>Add Category</h3>
            <p>Create a new game category</p>
        </a>

        <a href="{{ route('admin.games.create') }}" class="quick-link-card">
            <div class="quick-link-icon">
                <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="12" y1="5" x2="12" y2="19"></line>
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                </svg>
            </div>
            <h3>Add Game</h3>
            <p>Add a new game to the store</p>
        </a>

        <a href="{{ route('admin.products.create') }}" class="quick-link-card">
            <div class="quick-link-icon">
                <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="12" y1="5" x2="12" y2="19"></line>
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                </svg>
            </div>
            <h3>Add Product</h3>
            <p>Create a new product item</p>
        </a>

        <a href="{{ route('home') }}" class="quick-link-card">
            <div class="quick-link-icon">
                <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M18 13v6a2 2 0 01-2 2H5a2 2 0 01-2-2V8a2 2 0 012-2h6"></path>
                    <polyline points="15 3 21 3 21 9"></polyline>
                    <line x1="10" y1="14" x2="21" y2="3"></line>
                </svg>
            </div>
            <h3>View Website</h3>
            <p>Check your frontend store</p>
        </a>
    </div>
</div>
@endsection
