@extends('admin.layout')

@section('title', 'Create Category')
@section('page-title', 'Create New Category')

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.categories.store') }}" method="POST" data-validate>
            @csrf

            <div class="form-grid">
                <div class="form-group">
                    <label for="name" class="form-label required">Category Name</label>
                    <input type="text" id="name" name="name" class="form-input" value="{{ old('name') }}" required data-slug-source="slug" placeholder="e.g., Mobile Games">
                </div>

                <div class="form-group">
                    <label for="slug" class="form-label required">Slug (URL-friendly name)</label>
                    <input type="text" id="slug" name="slug" class="form-input" value="{{ old('slug') }}" required placeholder="e.g., mobile-games">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Auto-generated from name, or enter custom slug</small>
                </div>

                <div class="form-group">
                    <label for="description" class="form-label">Description</label>
                    <textarea id="description" name="description" class="form-textarea" placeholder="Brief description of this category">{{ old('description') }}</textarea>
                </div>

                <div class="form-group">
                    <label for="sort_order" class="form-label">Sort Order</label>
                    <input type="number" id="sort_order" name="sort_order" class="form-input" value="{{ old('sort_order', 0) }}" min="0">
                    <small style="color: var(--admin-text-secondary); font-size: 0.875rem;">Lower numbers appear first</small>
                </div>

                <div class="form-group">
                    <div class="checkbox-group">
                        <input type="checkbox" id="is_active" name="is_active" class="form-checkbox" {{ old('is_active', true) ? 'checked' : '' }}>
                        <label for="is_active" class="checkbox-label">Active (visible on website)</label>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <a href="{{ route('admin.categories.index') }}" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 21H5a2 2 0 01-2-2V5a2 2 0 012-2h11l5 5v11a2 2 0 01-2 2z"></path>
                        <polyline points="17 21 17 13 7 13 7 21"></polyline>
                        <polyline points="7 3 7 8 15 8"></polyline>
                    </svg>
                    Create Category
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
