/**
 * Gaming Platform - Games Page JavaScript
 * ========================================
 * Interactive features for the games page
 */

document.addEventListener('DOMContentLoaded', function() {
    
    // Search functionality
    const searchInput = document.querySelector('.search-bar input');
    if (searchInput) {
        searchInput.addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            const gameCards = document.querySelectorAll('.game-card');
            
            gameCards.forEach(card => {
                const title = card.querySelector('.game-title')?.textContent.toLowerCase();
                if (title && title.includes(searchTerm)) {
                    card.style.display = '';
                } else {
                    card.style.display = 'none';
                }
            });
        });
    }

    // Category filter
    const categoryTabs = document.querySelectorAll('.tab');
    categoryTabs.forEach(tab => {
        tab.addEventListener('click', function() {
            // Remove active from all tabs
            categoryTabs.forEach(t => t.classList.remove('active'));
            // Add active to clicked tab
            this.classList.add('active');
            
            // Filter games (placeholder - you can add category data attributes)
            console.log('Category selected:', this.textContent.trim());
        });
    });

    // Game card click
    const gameCards = document.querySelectorAll('.game-card');
    gameCards.forEach(card => {
        card.addEventListener('click', function() {
            const gameName = this.querySelector('.game-title')?.textContent;
            console.log('Game clicked:', gameName);
            // Add your game detail logic here
        });
    });

    // Play button animation
    const playButtons = document.querySelectorAll('.play-btn');
    playButtons.forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            this.style.transform = 'scale(0.95)';
            setTimeout(() => {
                this.style.transform = '';
            }, 150);
        });
    });

    // Update buttons
    const updateButtons = document.querySelectorAll('.btn-update');
    updateButtons.forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            this.textContent = 'Updating...';
            this.disabled = true;
            
            // Simulate update
            setTimeout(() => {
                this.textContent = 'Updated ✓';
                this.style.background = '#d1fae5';
                this.style.color = '#065f46';
                this.style.borderColor = '#a7f3d0';
            }, 1500);
        });
    });

    // Cancel download
    const cancelBtn = document.querySelector('.btn-cancel');
    if (cancelBtn) {
        cancelBtn.addEventListener('click', function() {
            const downloadItem = this.closest('.download-item');
            if (confirm('Cancel this download?')) {
                downloadItem.style.opacity = '0';
                downloadItem.style.transform = 'translateX(20px)';
                setTimeout(() => downloadItem.remove(), 300);
            }
        });
    }

    // Animate game icons on load
    const gameIcons = document.querySelectorAll('.game-image .game-icon');
    gameIcons.forEach((icon, index) => {
        icon.style.opacity = '0';
        icon.style.transform = 'scale(0.8)';
        setTimeout(() => {
            icon.style.transition = 'all 0.3s ease';
            icon.style.opacity = '1';
            icon.style.transform = 'scale(1)';
        }, index * 100);
    });

});

console.log('🎮 Games Page JS Loaded!');
