/**
 * Gaming Platform - Auth Page JavaScript
 * =======================================
 * Interactive features for login & register pages
 */

document.addEventListener('DOMContentLoaded', function() {
    
    // Password visibility toggle is now handled inline in register.blade.php with SVG icons
    
    // Form validation
    const authForms = document.querySelectorAll('.auth-form');
    authForms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const submitBtn = this.querySelector('button[type="submit"]');
            
            // Check if all required fields are filled
            const requiredInputs = this.querySelectorAll('input[required]');
            let isValid = true;
            
            requiredInputs.forEach(input => {
                if (!input.value.trim()) {
                    isValid = false;
                    input.style.borderColor = '#ef4444';
                } else {
                    input.style.borderColor = '';
                }
            });

            if (!isValid) {
                e.preventDefault();
                return;
            }

            // Password confirmation check (for register)
            const password = this.querySelector('#password');
            const passwordConfirm = this.querySelector('#password_confirmation');
            
            if (password && passwordConfirm) {
                if (password.value !== passwordConfirm.value) {
                    e.preventDefault();
                    passwordConfirm.style.borderColor = '#ef4444';
                    alert('Passwords do not match!');
                    return;
                }
            }

            // Email validation
            const emailInput = this.querySelector('input[type="email"]');
            if (emailInput) {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(emailInput.value)) {
                    e.preventDefault();
                    emailInput.style.borderColor = '#ef4444';
                    alert('Please enter a valid email address!');
                    return;
                }
            }

            // Add loading state
            if (submitBtn) {
                submitBtn.disabled = true;
                const originalText = submitBtn.innerHTML;
                submitBtn.innerHTML = '<span>Processing...</span>';
            }
        });

        // Clear error state on input
        const inputs = form.querySelectorAll('input');
        inputs.forEach(input => {
            input.addEventListener('input', function() {
                this.style.borderColor = '';
            });
        });
    });

    // Social login buttons
    const socialButtons = document.querySelectorAll('.social-btn');
    socialButtons.forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            const provider = this.textContent.trim();
            alert(`${provider} login coming soon!`);
        });
    });

    // Input focus animations
    const inputs = document.querySelectorAll('.input-wrapper input');
    inputs.forEach(input => {
        input.addEventListener('focus', function() {
            this.closest('.input-wrapper').style.transform = 'scale(1.02)';
        });
        
        input.addEventListener('blur', function() {
            this.closest('.input-wrapper').style.transform = '';
        });
    });

    // Auto-hide alerts
    setTimeout(() => {
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(alert => {
            alert.style.transition = 'opacity 0.3s, transform 0.3s';
            alert.style.opacity = '0';
            alert.style.transform = 'translateY(-10px)';
            setTimeout(() => alert.remove(), 300);
        });
    }, 5000);

    // Animate brand logo
    const brandLogo = document.querySelector('.brand-logo');
    if (brandLogo) {
        setInterval(() => {
            brandLogo.style.transform = 'scale(1.1) rotate(5deg)';
            setTimeout(() => {
                brandLogo.style.transform = '';
            }, 200);
        }, 3000);
    }

    // Anime.js Animations for auth-left
    if (typeof anime !== 'undefined') {
        const authLeft = document.querySelector('.auth-left');
        
        if (authLeft) {
            // Initial fade in animation for the entire left section
            anime({
                targets: '.auth-left',
                opacity: [0, 1],
                translateX: [-50, 0],
                duration: 1200,
                easing: 'easeOutExpo'
            });

            // Animate brand elements with stagger
            anime({
                targets: '.auth-brand > *',
                opacity: [0, 1],
                translateY: [20, 0],
                delay: anime.stagger(150, {start: 400}),
                duration: 800,
                easing: 'easeOutExpo'
            });
        }
    }

});

console.log('🔐 Auth Page JS Loaded!');
