<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Game;
use App\Models\Product;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class GameStoreSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Categories
        $moba = Category::create([
            'name' => 'MOBA Games',
            'slug' => 'moba-games',
            'description' => 'Multiplayer Online Battle Arena Games',
            'is_active' => true,
            'sort_order' => 1,
        ]);

        $battleRoyale = Category::create([
            'name' => 'Battle Royale',
            'slug' => 'battle-royale',
            'description' => 'Battle Royale Games',
            'is_active' => true,
            'sort_order' => 2,
        ]);

        $rpg = Category::create([
            'name' => 'RPG Games',
            'slug' => 'rpg-games',
            'description' => 'Role Playing Games',
            'is_active' => true,
            'sort_order' => 3,
        ]);

        // Mobile Legends
        $ml = Game::create([
            'category_id' => $moba->id,
            'name' => 'Mobile Legends',
            'slug' => 'ml',
            'image' => 'games/ml.jpg',
            'description' => 'Mobile Legends: Bang Bang',
            'developer' => 'Moonton',
            'is_popular' => true,
            'is_active' => true,
            'sort_order' => 1,
        ]);

        // ML Products
        Product::create(['game_id' => $ml->id, 'name' => '50 Diamonds', 'price' => 15000, 'original_price' => 18000, 'sort_order' => 1]);
        Product::create(['game_id' => $ml->id, 'name' => '100 Diamonds', 'price' => 28000, 'original_price' => 32000, 'sort_order' => 2]);
        Product::create(['game_id' => $ml->id, 'name' => '250 Diamonds', 'price' => 70000, 'original_price' => 80000, 'sort_order' => 3]);
        Product::create(['game_id' => $ml->id, 'name' => '500 Diamonds', 'price' => 135000, 'original_price' => 155000, 'sort_order' => 4]);
        Product::create(['game_id' => $ml->id, 'name' => '1000 Diamonds', 'price' => 270000, 'original_price' => 300000, 'sort_order' => 5]);

        // Free Fire
        $ff = Game::create([
            'category_id' => $battleRoyale->id,
            'name' => 'Free Fire',
            'slug' => 'ff',
            'image' => 'games/ff.jpg',
            'description' => 'Garena Free Fire',
            'developer' => 'Garena',
            'is_popular' => true,
            'is_active' => true,
            'sort_order' => 2,
        ]);

        // FF Products
        Product::create(['game_id' => $ff->id, 'name' => '50 Diamonds', 'price' => 7000, 'original_price' => 9000, 'sort_order' => 1]);
        Product::create(['game_id' => $ff->id, 'name' => '100 Diamonds', 'price' => 14000, 'original_price' => 17000, 'sort_order' => 2]);
        Product::create(['game_id' => $ff->id, 'name' => '500 Diamonds', 'price' => 70000, 'original_price' => 85000, 'sort_order' => 3]);

        // PUBG Mobile
        $pubg = Game::create([
            'category_id' => $battleRoyale->id,
            'name' => 'PUBG Mobile',
            'slug' => 'pubgm',
            'image' => 'games/pubg.jpg',
            'description' => 'PUBG Mobile',
            'developer' => 'Tencent',
            'is_popular' => true,
            'is_active' => true,
            'sort_order' => 3,
        ]);

        // PUBG Products
        Product::create(['game_id' => $pubg->id, 'name' => '60 UC', 'price' => 16000, 'original_price' => 19000, 'sort_order' => 1]);
        Product::create(['game_id' => $pubg->id, 'name' => '300 UC', 'price' => 80000, 'original_price' => 95000, 'sort_order' => 2]);
        Product::create(['game_id' => $pubg->id, 'name' => '600 UC', 'price' => 160000, 'original_price' => 190000, 'sort_order' => 3]);

        // Genshin Impact
        $genshin = Game::create([
            'category_id' => $rpg->id,
            'name' => 'Genshin Impact',
            'slug' => 'genshin',
            'image' => 'games/genshin.jpg',
            'description' => 'Genshin Impact',
            'developer' => 'miHoYo',
            'is_popular' => true,
            'is_active' => true,
            'sort_order' => 4,
        ]);

        // Genshin Products
        Product::create(['game_id' => $genshin->id, 'name' => '60 Genesis Crystals', 'price' => 16000, 'original_price' => 19000, 'sort_order' => 1]);
        Product::create(['game_id' => $genshin->id, 'name' => '300 Genesis Crystals', 'price' => 79000, 'original_price' => 95000, 'sort_order' => 2]);
        Product::create(['game_id' => $genshin->id, 'name' => '980 Genesis Crystals', 'price' => 249000, 'original_price' => 299000, 'sort_order' => 3]);

        // Arena of Valor
        $aov = Game::create([
            'category_id' => $moba->id,
            'name' => 'Arena of Valor',
            'slug' => 'aov',
            'image' => 'games/aov.jpg',
            'description' => 'Arena of Valor',
            'developer' => 'Tencent',
            'is_popular' => false,
            'is_active' => true,
            'sort_order' => 5,
        ]);

        // AOV Products
        Product::create(['game_id' => $aov->id, 'name' => '50 Vouchers', 'price' => 14000, 'original_price' => 17000, 'sort_order' => 1]);
        Product::create(['game_id' => $aov->id, 'name' => '100 Vouchers', 'price' => 27000, 'original_price' => 33000, 'sort_order' => 2]);
    }
}
