<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_id', 20)->unique();  // Format: RIS-XXXXXXXX
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->foreignId('flash_sale_id')->nullable()->constrained()->onDelete('set null');

            // Customer Info
            $table->string('game_user_id');  // ID game user
            $table->string('game_server_id')->nullable();  // Zone/Server ID (optional)
            $table->string('whatsapp', 20);
            $table->string('email')->nullable();

            // Price Info
            $table->decimal('original_price', 10, 2);  // Harga normal produk
            $table->decimal('final_price', 10, 2);  // Harga yang dibayar (bisa flash sale)
            $table->decimal('discount_amount', 10, 2)->default(0);  // Potongan harga

            // Order Status
            $table->enum('status', ['pending', 'paid', 'processing', 'completed', 'failed', 'refunded', 'expired'])->default('pending');
            $table->enum('payment_method', ['manual', 'qris', 'ewallet', 'bank_transfer', 'va'])->nullable();
            $table->string('payment_proof')->nullable();  // Bukti pembayaran untuk manual

            // Timestamps
            $table->timestamp('paid_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->timestamp('expired_at')->nullable();

            // Notes
            $table->text('admin_notes')->nullable();
            $table->text('customer_notes')->nullable();

            $table->timestamps();

            // Indexes
            $table->index('status');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
