<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('flash_sales', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->decimal('flash_price', 10, 2);  // Harga flash sale
            $table->integer('flash_stock');  // Stok khusus flash sale
            $table->integer('sold')->default(0);  // Jumlah terjual
            $table->datetime('start_time');  // Waktu mulai flash sale
            $table->datetime('end_time');  // Waktu berakhir flash sale
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('flash_sales');
    }
};
