<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('game_id')->constrained()->onDelete('cascade');
            $table->string('name');  // contoh: "50 Diamonds"
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2);  // harga dalam Rupiah
            $table->decimal('original_price', 10, 2)->nullable();  // harga coret
            $table->integer('stock')->default(9999);  // stok unlimited bisa set 9999
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
