#!/bin/bash

# Webtopup Backup Script
# Membuat backup zip dengan timestamp

# Warna untuk output
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Konfigurasi
PROJECT_DIR="/var/www/webtopup"
BACKUP_DIR="$PROJECT_DIR/backups"
TIMESTAMP=$(date +%Y%m%d-%H%M%S)
BACKUP_NAME="webtopup-backup-$TIMESTAMP.zip"

# Buat folder backup jika belum ada
mkdir -p "$BACKUP_DIR"

echo -e "${YELLOW}Starting backup...${NC}"
echo "Project: $PROJECT_DIR"
echo "Backup file: $BACKUP_NAME"
echo ""

# Pindah ke parent directory
cd /var/www

# Buat backup zip dengan exclusions
zip -r "$BACKUP_DIR/$BACKUP_NAME" webtopup \
  -x "webtopup/vendor/*" \
  -x "webtopup/node_modules/*" \
  -x "webtopup/storage/logs/*" \
  -x "webtopup/storage/framework/cache/*" \
  -x "webtopup/storage/framework/sessions/*" \
  -x "webtopup/storage/framework/views/*" \
  -x "webtopup/backups/*" \
  -x "webtopup/.git/*" \
  -q

# Cek hasil backup
if [ $? -eq 0 ]; then
    BACKUP_SIZE=$(du -h "$BACKUP_DIR/$BACKUP_NAME" | cut -f1)
    echo -e "${GREEN}✓ Backup berhasil!${NC}"
    echo "Location: $BACKUP_DIR/$BACKUP_NAME"
    echo "Size: $BACKUP_SIZE"
    echo ""
    
    # Tampilkan list backup yang ada
    echo -e "${YELLOW}Existing backups:${NC}"
    ls -lh "$BACKUP_DIR" | grep "webtopup-backup"
else
    echo "✗ Backup gagal!"
    exit 1
fi
