<?php

if (!function_exists('is_production')) {
    /**
     * Check if the application is running in production environment
     */
    function is_production(): bool
    {
        return app()->environment('production');
    }
}

if (!function_exists('is_local')) {
    /**
     * Check if the application is running in local environment
     */
    function is_local(): bool
    {
        return app()->environment('local');
    }
}

if (!function_exists('is_hosted')) {
    /**
     * Check if the application is hosted (not localhost)
     */
    function is_hosted(): bool
    {
        $host = request()->getHost();
        return !in_array($host, ['localhost', '127.0.0.1', '::1']);
    }
}

if (!function_exists('app_url')) {
    /**
     * Get the application URL based on environment
     */
    function app_url(string $path = ''): string
    {
        $url = config('app.url');

        // Auto-detect if in production
        if (is_production() || is_hosted()) {
            $scheme = request()->secure() ? 'https' : 'http';
            $host = request()->getHost();
            $url = "{$scheme}://{$host}";
        }

        return rtrim($url, '/') . '/' . ltrim($path, '/');
    }
}

if (!function_exists('asset_url')) {
    /**
     * Get asset URL with auto HTTPS in production
     */
    function asset_url(string $path): string
    {
        if (is_production() || is_hosted()) {
            return secure_asset($path);
        }
        return asset($path);
    }
}
