<?php

namespace App\Providers;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register WhatsApp notification channel
        Notification::extend('whatsapp', function ($app) {
            return new \App\Channels\WhatsAppChannel();
        });

        // Auto-detect production environment and force HTTPS
        if ($this->app->environment('production') ||
                request()->server('HTTP_X_FORWARDED_PROTO') === 'https' ||
                request()->server('HTTPS') === 'on') {
            URL::forceScheme('https');
        }

        // Set trusted proxies for Cloudflare or other CDN
        if (config('app.env') === 'production') {
            $this->app['request']->setTrustedProxies(
                ['0.0.0.0/0'],
                \Illuminate\Http\Request::HEADER_X_FORWARDED_FOR
                    | \Illuminate\Http\Request::HEADER_X_FORWARDED_HOST
                    | \Illuminate\Http\Request::HEADER_X_FORWARDED_PORT
                    | \Illuminate\Http\Request::HEADER_X_FORWARDED_PROTO
            );
        }
    }
}
