<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Game extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'name',
        'slug',
        'image',
        'description',
        'developer',
        'is_popular',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'is_popular' => 'boolean',
        'is_active' => 'boolean',
    ];

    /**
     * Get the category that owns the game
     */
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * Get all products for this game
     */
    public function products()
    {
        return $this->hasMany(Product::class);
    }

    /**
     * Get active products for this game
     */
    public function activeProducts()
    {
        return $this->hasMany(Product::class)->where('is_active', true)->orderBy('sort_order');
    }
}
