<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'icon',
        'description',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get all games in this category
     */
    public function games()
    {
        return $this->hasMany(Game::class);
    }

    /**
     * Get active games in this category
     */
    public function activeGames()
    {
        return $this->hasMany(Game::class)->where('is_active', true)->orderBy('sort_order');
    }
}
