<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TopUpController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // Popular Games untuk Top Up
        $popularGames = [
            [
                'title' => 'Mobile Legends',
                'subtitle' => 'Diamond Top Up',
                'icon' => '⚔️',
                'category' => 'MOBA'
            ],
            [
                'title' => 'Free Fire',
                'subtitle' => 'Diamond Top Up',
                'icon' => '🔥',
                'category' => 'Battle Royale'
            ],
            [
                'title' => 'PUBG Mobile',
                'subtitle' => 'UC Top Up',
                'icon' => '🎯',
                'category' => 'Battle Royale'
            ]
        ];

        // Game Categories untuk Top Up
        $gameCategories = [
            [
                'title' => 'Mobile Legends',
                'price' => 'Mulai dari Rp 10.000',
                'stock' => 'Ready Stock',
                'image' => '⚔️'
            ],
            [
                'title' => 'Free Fire',
                'price' => 'Mulai dari Rp 5.000',
                'stock' => 'Ready Stock',
                'image' => '🔥'
            ],
            [
                'title' => 'PUBG Mobile',
                'price' => 'Mulai dari Rp 15.000',
                'stock' => 'Ready Stock',
                'image' => '🎯'
            ],
            [
                'title' => 'Genshin Impact',
                'price' => 'Mulai dari Rp 20.000',
                'stock' => 'Ready Stock',
                'image' => '⭐'
            ]
        ];

        return view('topup.index', compact('popularGames', 'gameCategories', 'user'));
    }
}
