<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\FlashSale;
use App\Models\Game;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Display the home page with all games
     */
    public function index()
    {
        $categories = Category::where('is_active', true)
            ->orderBy('sort_order')
            ->withCount('activeGames')
            ->get();

        $popularGames = Game::where('is_active', true)
            ->where('is_popular', true)
            ->with('category')
            ->orderBy('sort_order')
            ->get();

        $allGames = Game::where('is_active', true)
            ->with('category')
            ->orderBy('sort_order')
            ->get();

        // Get active flash sales for homepage
        $activeFlashSales = FlashSale::with('product.game')
            ->currentlyRunning()
            ->orderBy('end_time')
            ->take(4)
            ->get();

        return view('home.index', compact('categories', 'popularGames', 'allGames', 'activeFlashSales'));
    }

    /**
     * Display games by category
     */
    public function category($slug)
    {
        $category = Category::where('slug', $slug)
            ->where('is_active', true)
            ->firstOrFail();

        $games = Game::where('category_id', $category->id)
            ->where('is_active', true)
            ->orderBy('sort_order')
            ->get();

        return view('home.category', compact('category', 'games'));
    }
}
