<?php

namespace App\Http\Controllers;

use App\Models\FlashSale;
use Illuminate\Http\Request;

class FlashSaleController extends Controller
{
    /**
     * Display the flash sale page
     */
    public function index()
    {
        // Get currently running flash sales
        $activeFlashSales = FlashSale::with('product.game')
            ->currentlyRunning()
            ->orderBy('end_time')
            ->get();

        // Get upcoming flash sales
        $upcomingFlashSales = FlashSale::with('product.game')
            ->upcoming()
            ->orderBy('start_time')
            ->take(6)
            ->get();

        return view('flash-sale.index', compact('activeFlashSales', 'upcomingFlashSales'));
    }

    /**
     * API endpoint to get flash sale status (for AJAX countdown updates)
     */
    public function status(FlashSale $flashSale)
    {
        return response()->json([
            'is_active' => $flashSale->isCurrentlyActive(),
            'remaining_stock' => $flashSale->getRemainingStock(),
            'sold' => $flashSale->sold,
            'has_ended' => $flashSale->hasEnded(),
            'is_sold_out' => $flashSale->isSoldOut(),
            'time_remaining' => $flashSale->getTimeRemainingInSeconds(),
            'status_label' => $flashSale->getStatusLabel(),
        ]);
    }
}
