<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Game;
use App\Models\Product;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    /**
     * Display admin dashboard
     */
    public function dashboard()
    {
        $stats = [
            'categories' => Category::count(),
            'games' => Game::count(),
            'products' => Product::count(),
            'active_games' => Game::where('is_active', true)->count(),
        ];

        $recentGames = Game::with('category')
            ->latest()
            ->take(5)
            ->get();

        return view('admin.dashboard', compact('stats', 'recentGames'));
    }
}
